package com.datastax.data.prepare.spark.dataset.params;

import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;

import java.io.Serializable;

public class ColumnReduceParam implements Serializable{
    private String mergeColumns;
    private String connectSymbol;
    private String newColumnName;
    private DataType dataType;

    public ColumnReduceParam() {
    }

    public ColumnReduceParam(String mergeColumns, String connectSymbol, String newColumnName, DataType dataType) {
        this.mergeColumns = mergeColumns;
        this.connectSymbol = connectSymbol == null ? "" : connectSymbol;
        this.newColumnName = newColumnName;
        this.dataType = dataType;
    }

    public String getMergeColumns() {
        return mergeColumns;
    }

    public void setMergeColumns(String mergeColumns) {
        this.mergeColumns = mergeColumns;
    }

    public String getConnectSymbol() {
        return connectSymbol;
    }

    public void setConnectSymbol(String connectSymbol) {
        this.connectSymbol = connectSymbol == null ? "" : connectSymbol;
    }

    public String getNewColumnName() {
        return newColumnName;
    }

    public void setNewColumnName(String newColumnName) {
        this.newColumnName = newColumnName;
    }

    public DataType getDataType() {
        return dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType(dataType);
    }

    @Override
    public String toString() {
        return "ColumnReduceParam{" +
                "mergeColumns='" + mergeColumns + '\'' +
                ", connectSymbol='" + connectSymbol + '\'' +
                ", newColumnName='" + newColumnName + '\'' +
                ", dataType=" + dataType +
                '}';
    }

    private DataType dataType(String type) {
        switch(type) {
            case "String" :
                return DataTypes.StringType;
            case "Vector" :
                return new VectorUDT();
            case "Numeric" :
                return DataTypes.DoubleType;
            case "Date" :
                return DataTypes.DateType;
            case "Timestamp" :
                return DataTypes.TimestampType;
            default :
                return DataTypes.StringType;
        }

    }
}
