package com.datastax.data.prepare.spark.dataset.params;

import com.datastax.data.prepare.util.Consts;
import com.datastax.data.prepare.util.CustomException;
import com.google.common.base.Strings;

public class DataBinning extends Attributes {
    private String binningType;  //分箱类型, 分为大小离散化、分级离散化、频率离散化、用户自定离散化、熵离散化
    private int binSize;  //数值在每个 binningType 都有所不同
    private boolean defineBoundaries;  //作用于 binningType 为 分级离散化 时，true 表示 分级的上限和下限由用户指定
    private double minValue;  //分级离散化 的 下限
    private double maxValue;  //分级离散化 的 上限
    private String[] classNames;
    private double[] upperLimits;

    public static class Builder extends Attributes {
        private String binningType;
        private int binSize;
        private boolean defineBoundaries = false;
        private double minValue = 0;
        private double maxValue = 0;
        private String[] classNames;
        private double[] upperLimits;
        public Builder() {
        }

        public Builder attributeSelector(String attributeSelector) {
            super.setAttributeSelector(attributeSelector);
            return this;
        }

        public Builder invertSelection(boolean invertSelection) {
            super.setInvertSelection(invertSelection);
            return this;
        }

        public Builder attribute(String attribute) {
            super.setAttribute(attribute);
            return this;
        }

        public Builder regularExpression(String regularExpression) {
            super.setRegularExpression(regularExpression);
            return this;
        }

        public Builder valueType(String valueType) {
            super.setValueType(valueType);
            return this;
        }

        public Builder binningType(String binningType) {
            this.binningType = binningType;
            return this;
        }

        public Builder binSize(int binSize) {
            this.binSize = binSize;
            return this;
        }

        public Builder defineBoundaries(boolean defineBoundaries) {
            this.defineBoundaries = defineBoundaries;
            return this;
        }

        public Builder minValue(double minValue) {
            this.minValue = minValue;
            return this;
        }

        public Builder maxValue(double maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public Builder params(String[] classNames, String[] upperLimits) {
            if(upperLimits == null || classNames == null) {
                throw new CustomException("用户自定离散化参数为空");
            }
            if(upperLimits.length != classNames.length) {
                throw new CustomException("用户自定离散化的参数长度不等");
            }
            int count = 0;
            boolean negativeInfinity = false;
            boolean positiveInfinity = false;
            boolean repeat;
            int position = 0;
            int position1 = 0;
            int position2 = 0;
            double[] temp1 = new double[upperLimits.length];
            int[] signs = new int[upperLimits.length];
            double temp3 ;
            for(int i=0; i<upperLimits.length; i++) {
                if(Strings.isNullOrEmpty(upperLimits[i]) || Strings.isNullOrEmpty(classNames[i])) {
                    continue;
                }
                if(Consts.NEGATIVE_INFINITY.equals(upperLimits[i])) {
                    negativeInfinity = true;
                    position1 = i;
                    continue;
                }
                if(Consts.POSITIVE_INFINITY.equals(upperLimits[i])) {
                    positiveInfinity = true;
                    position2 = i;
                    continue;
                }
//                可能会出现转换不了问题
                try {
                    temp3 = Double.parseDouble(upperLimits[i]);
                }catch (NumberFormatException e) {
                    throw new CustomException("String转Double失败");
                }

                if(count == 0) {
                    temp1[count] = temp3;
                    signs[count] = i;
                    count++;
                    continue;
                }
                repeat = false;
                for(int j=0; j<count; j++) {
                    if(temp3 == temp1[j]) {
                        repeat = true;
                        break;
                    }
                }
                if(!repeat) {
                    temp1[count] = temp3;
                    signs[count] = i;
                    count++;
                }
            }
            double[] doubles = new double[count+2];
            String[] strings = new String[count+2];
            if(negativeInfinity) {
                doubles[position] = Double.NEGATIVE_INFINITY;
                strings[position] = classNames[position1];
            }else {
                doubles[position] = Double.NEGATIVE_INFINITY;
                strings[position] = Consts.NEGATIVE_INFINITY;
            }
            for(int i=0; i<count; i++) {
                double min = temp1[i];
                position1 = i;
                for(int j=i; j<count; j++) {
                    if(temp1[j] < min) {
                        position1 = j;
                        min = temp1[j];
                    }
                }
                if(position1 != i) {
                    double a = temp1[i];
                    temp1[i] = min;
                    temp1[position1] = a;
                }
                doubles[++position] = min;
                strings[position] = classNames[signs[position1]];
            }
            if(positiveInfinity) {
                doubles[++position] = Double.POSITIVE_INFINITY;
                strings[position] = classNames[position2];
            }else {
                doubles[++position] = Double.POSITIVE_INFINITY;
                strings[position] = Consts.POSITIVE_INFINITY;
            }
            this.upperLimits = doubles;
            this.classNames = strings;
            return this;
        }

        public DataBinning build() {
            return new DataBinning(this);
        }
    }

    private DataBinning(Builder builder) {
        super(builder.getAttributeSelector(), builder.isInvertSelection(), builder.getAttribute(), builder.getRegularExpression(), builder.getValueType());
        this.binningType = builder.binningType;
        this.binSize = builder.binSize;
        this.defineBoundaries = builder.defineBoundaries;
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.classNames = builder.classNames;
        this.upperLimits = builder.upperLimits;
    }

    public String getBinningType() {
        return binningType;
    }

    public int getBinSize() {
        return binSize;
    }

    public boolean isDefineBoundaries() {
        return defineBoundaries;
    }

    public double getMinValue() {
        return minValue;
    }

    public double getMaxValue() {
        return maxValue;
    }

    public String[] getClassNames() {
        return classNames;
    }

    public double[] getUpperLimits() {
        return upperLimits;
    }
}
