package com.datastax.data.prepare.spark.dataset.params;

import java.io.Serializable;

//将一列的值按照一定规则拆分成多列
public class FlatMapParam implements Serializable {
    private String column; //列名
    private String pattern; //regex
    private int sliceNum; //分片数, 如果不设置该值，在拆分选中列中每行的值时可能会有不同的分片数
    private String sliceColumnName; //以分号隔开, 值为空则为默认值

    public FlatMapParam(String column, String pattern, int sliceNum, String sliceColumnName) {
        this.column = column;
        this.pattern = pattern;
        this.sliceNum = sliceNum;
        this.sliceColumnName = sliceColumnName;
    }

    public FlatMapParam() {
    }

    public String getColumn() {
        return column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getPattern() {
        return pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public int getSliceNum() {
        return sliceNum;
    }

    public void setSliceNum(int sliceNum) {
        this.sliceNum = sliceNum;
    }

    public String getSliceColumnName() {
        return sliceColumnName;
    }

    public void setSliceColumnName(String sliceColumnName) {
        this.sliceColumnName = sliceColumnName;
    }



    @Override
    public String toString() {
        return "FlatMapParam{" +
                "column='" + column + '\'' +
                ", pattern='" + pattern + '\'' +
                ", sliceNum=" + sliceNum +
                ", sliceColumnName='" + sliceColumnName + '\'' +
                '}';
    }
}
