package com.datastax.data.prepare.spark.dataset.params;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ReplaceAttribute extends Attributes {

    private List<FilterSection> filterSections = new ArrayList<>();
    private List<ValueReplaceAttribute> valueReplaceAttributes = new ArrayList<>();

    public ReplaceAttribute() {}

    public class ValueReplaceAttribute implements Serializable {
        private boolean regex;
        private String oldValue;
        private String newValue;

        private ValueReplaceAttribute() {}

        private ValueReplaceAttribute(boolean regex, String oldValue, String newValue) {
            this.regex = regex;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public boolean isRegex() {
            return regex;
        }

        public void setRegex(boolean regex) {
            this.regex = regex;
        }

        public String getOldValue() {
            return oldValue;
        }

        public void setOldValue(String oldValue) {
            this.oldValue = oldValue;
        }

        public String getNewValue() {
            return newValue;
        }

        public void setNewValue(String newValue) {
            this.newValue = newValue;
        }
    }


    public List<FilterSection> getFilterSections() {
        return filterSections;
    }

    public void addFilterSections(FilterSection filterSection) {
        this.filterSections.add(filterSection);
    }

    public List<ValueReplaceAttribute> getValueReplaceAttributes() {
        return valueReplaceAttributes;
    }

    public void addValueReplaceAttributes(boolean regex, String oldValue, String newValue) {
        this.valueReplaceAttributes.add(new ValueReplaceAttribute(regex, oldValue, newValue));
    }
}
