package com.datastax.data.prepare.spark.math

object DistanceMetricMethods {

  def euclidianDistance(xs: Array[Double], ys: Array[Double]): Double = Math.sqrt(squaredDistance(xs, ys))

  def squaredDistance(xs: Array[Double], ys: Array[Double]): Double = VectorCorrelation.vectorFunc(xs, ys)((x: Double, y: Double) => (y - x) * (y - x))
//    xs.indices.foldLeft(0.0)((sum: Double, i: Int) => (ys(i) - xs(i)) * (ys(i) - xs(i)) + sum) //相同效果，但是慢几毫秒

  def cosineDistance(xs: Array[Double], ys: Array[Double]): Double = VectorCorrelation.dot(xs, ys) / VectorCorrelation.vectorDist(xs, ys)

  def invertedCosineDistance(xs: Array[Double], ys: Array[Double]): Double = 1 / cosineDistance(xs, ys)

  def manhattanDistance(xs: Array[Double], ys: Array[Double]): Double = Math.abs(VectorCorrelation.vectorFunc(xs, ys)(_ + _))

}
