package com.datastax.data.prepare.spark.rdd;

import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.spec.RDDOperator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils;

public class RDDLoader implements RDDOperator {
    public static JavaRDD<String> load(String path){
        JavaSparkContext sc= SparkContextBuilder.getJContext();
        return sc.textFile(path);
    }
    public static <T> JavaRDD<T> load(String path,RDDConverter converter){
        JavaRDD<String> lines=load(path);
        JavaRDD<T> rdd=lines.map(new Function<String, T>() {
            @Override
            public T call(String line) throws Exception {
                return converter.convert(line);
            }
        });
        return rdd;
    }

    public static JavaRDD<LabeledPoint> loadLibSVMFile(String path){
        return MLUtils.loadLibSVMFile(SparkContextBuilder.getContext(),path).toJavaRDD();
    }
}
