package com.datastax.data.prepare.util;

import org.apache.spark.sql.Column;

public interface Consts {
    String DELIMITER=";";
    String NEWLINE=System.getProperty("line.separator");

//    DataSetTransformation
    String SORT = "sort";
    String SORT_WIRHINPARTITIONS = "sortWithinPartitions";
    String ORDERBY = "orderBy";
    String COLUMN = "column";
    String EXPRESSION = "expression";
    String DROP = "drop";
    String DROP_DUPLICATES = "drop duplicates";
    String DESC = "DESC";

//    BasicOperator Consts
    String INCREMENT = "Increment"; //自增组件
    String GROUPBY = "groupBy";
    String ROLLUP = "rollup";
    String CUBE = "cube";
    String MIN = "min";
    String MAX = "max";
    String AVG = "avg";
    String SUM = "sum";
    String COUNT = "count";
    String COLLECT_LIST = "collect_list";
    String COLLECT_SET = "collect_set";
    String DISTINCT_COUNT = "distinct_count";
    String DISTINCT_SUM = "distinct_sum";
    String APPROX_COUNT_DISTINCT = "approx_count_distinct";
    String ARRAY = "array";
    String RENAME = "重命名";
    String INITIALIZA_NAME = "初始化命名";
    String AUTO = "auto";
    String MANUAL = "manual";

//    FillDataOpeartor Consts
    String ALL = "All";
    String ATTRIBUTE_NAME = "Attribute Name";   //属性名
    String REGULAR_EXPRESSION = "Regular Expression";   //正则表达式
    String VALUE_TYPE = "Value Type";   //值类型
    String DROPEMPTY = "Drop Empty";  //丢弃空值的row
    String MINIMUM = "Minimum"; //最小值
    String MAXIMUM = "Maximum"; //最大值
    String AVERAGE = "Average";
    String ZERO = "Zero";   //0
    String VALUE = "Value"; //值
    String NUMERIC = "numeric"; //数值型
    String INTEGER = "integer"; //整数型
    String TIMESTAMP = "timestamp"; //日期时间型
    String DATE = "date";   //日期型
    String TEXT = "text";

//    TypeTransformation
    String DATE_TO_NUM = "Date to Number";
    String NUM_TO_DATE = "Number to Date";
    String FORMAT_NUMBER = "Format Number";
    String STRING_TO_LONG = "String to Long";
    String STRING_TO_DOUBLE = "String to Double";
    String STRING_TO_DATE = "String to Date";
    String STRING_TO_TIMESTAMP = "String to Timestamp";
    String INT_TO_DOUBLE = "Int to Double";
    String LONG_TO_DOUBLE = "Long to Double";
    String ROUND_UP = "ROUND_UP";
    String ROUND_DOWN = "ROUND_DOWN";
    String ROUND_CEILING = "ROUND_CEILING";
    String ROUND_HALF_UP = "ROUND_HALF_UP";
    String ROUND_HALF_DOWN = "ROUND_HALF_DOWN";
    String ROUND_HALF_EVEN = "ROUND_HALF_EVEN";

//    DataBinningOperator
    String SIZE = "大小离散化";  //Discretize by Size
    String BINNING = "分级离散化";  //Discretize by Binning
    String FREQUENCY = "频率离散化";  //Discretize by Frequency
    String USER_SPECIFICATION = "自定义离散化";  //Discretize by User Specification
    String ENTROPY = "最小熵离散化";  //Discretize by Entropy
    String NEGATIVE_INFINITY = "-Infinity";
    String POSITIVE_INFINITY = "Infinity";

//    OutilerDetectionOperator
    String EUCLIDIAN = "欧式距离";
    String SQUARED = "平方距离";
    String COSINE = "余弦距离";
    String INVERTED_COSINE = "反余弦距离";

//    FilterOperator
    String EQUALS = "equals";
    String DOES_NOT_EQUALS = "does not equals";
    String IS_IN = "is in";
    String IS_NOT_IN = "is not in";
    String CONTAINS = "contains";
    String DOES_NOT_CONTAINS = "does not contains";
    String START_WITH = "start with";
    String END_WITH = "end with";
    String MATCHES = "matches";
    String IS_MISSING = "is missing";
    String IS_NOT_MISSING = "is not missing";

//    ReplaceOperator
    String REPLACE = "替换";
    String REPLACE_BY_CONDITION = "条件替换";
    String ASTERRISK = "*";

     enum MathCompare {
        GT {
            @Override
            public Column compare(Column x, double y) {
                return x.gt(y);
            }
        },
        GT_EQ {
           @Override
           public Column compare(Column x, double y) {
               return x.geq(y);
           }
        },
        LT {
            @Override
            public Column compare(Column x, double y) {
                return x.lt(y);
            }
        },
        LT_EQ {
            @Override
            public Column compare(Column x, double y) {
                return x.leq(y);
            }
        },
        EQ {
            @Override
            public Column compare(Column x, double y) {
                return x.equalTo(y);
            }
        };

        public abstract Column compare(Column x, double y);

        public static MathCompare getType(String name) {
            switch(name) {
                case "大于":
                    return MathCompare.GT;
                case "不小于":
                    return MathCompare.GT_EQ;
                case "小于":
                    return MathCompare.LT;
                case "不大于":
                    return MathCompare.LT_EQ;
                case "等于":
                    return MathCompare.EQ;
                default:
                    throw new IllegalStateException(name + "不存在");
            }
        }
    }


}
