package com.datastax.data.prepare.util;

public class CustomException extends RuntimeException {
    private static final long serialVersionUID = 1L;

    private String errorCode;
    private boolean propertiesKey = true;

    public CustomException(String message) {
        super(message);
    }

    public CustomException(String errorCode, String message) {
        this(errorCode, message, true);
    }

    public CustomException(String errorCode, String message, Throwable cause) {
        this(errorCode, message, cause, true);
    }

    private CustomException(String errorCode, String message, boolean propertiesKey) {
        super(message);
        this.setErrorCode(errorCode);
        this.setPropertiesKey(propertiesKey);
    }

    private CustomException(String errorCode, String message, Throwable cause, boolean propertiesKey) {
        super(message, cause);
        this.setErrorCode(errorCode);
        this.setPropertiesKey(propertiesKey);
    }

    public CustomException(String message, Throwable cause) {
        super(message, cause);
    }

    public String getErrorCode() {
        return errorCode;
    }

    private void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public boolean isPropertiesKey() {
        return propertiesKey;
    }

    private void setPropertiesKey(boolean propertiesKey) {
        this.propertiesKey = propertiesKey;
    }
}
