package com.datastax.insight.ml.spark.data.dataset;

import com.datastax.insight.spec.Operator;
import com.datastax.insight.core.Consts;
import com.google.common.base.Strings;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.MapPartitionsFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import scala.Tuple2;

import java.util.Map;

import static org.apache.spark.sql.functions.col;

public class DataSetTransformation implements Operator {
    //// TODO: 16-10-20 未来需要支持前端表达式可视化构建
    public static <T> Dataset<Row> join(Dataset<T> left, Dataset<T> right, Column joinExprs,String joinType){
        return left.join(right,joinExprs,joinType);
    }

    public static <T> Dataset<Row> join(Dataset<T> left, Dataset<T> right, String keyLeft,String keyRight,String joinType){
        return left.join(right,col(keyLeft).equalTo(col(keyRight)),joinType);
    }

    public static <T,U> Dataset<Tuple2<T, U>> joinWith(Dataset<T> left, Dataset<U> right, Column joinExprs, String joinType){
        return left.joinWith(right,joinExprs,joinType);
    }

    public static <T> Dataset<T>[] split(Dataset<T> dataSet,double[] weights){
        return dataSet.randomSplit(weights);
    }

    public static <T> Dataset<T> union(Dataset<T> ds1,Dataset<T> ds2){
        return ds1.union(ds2);
    }

    public static <T,U> Dataset<U> as(Dataset<T> dataset,Encoder<U> u){
        return dataset.as(u);
    }

    @Transformal
    public static <T> Dataset<T> alias(Dataset<T> dataset,String alias){
        return dataset.as(alias);
    }

    public static <T> Dataset<T> sort(Dataset<T> dataset,String col,String... cols){
        return dataset.sort(col,cols);
    }

    @Transformal
    public static <T> Dataset<T> sort(Dataset<T> dataset,String col,String cols){
        String[] columns=cols.split(Consts.DELIMITER);
        return dataset.sort(col,columns);
    }

    public static <T> Dataset<T> sortWithinPartitions(Dataset<T> dataset,String col,String... cols){
        return dataset.sortWithinPartitions(col,cols);
    }

    @Transformal
    public static <T> Dataset<T> sortWithinPartitions(Dataset<T> dataset,String col,String cols){
        String[] columns=cols.split(Consts.DELIMITER);
        return dataset.sortWithinPartitions(col,columns);
    }

    public static <T> Dataset<T> orderBy(Dataset<T> dataset,String col,String... cols){
        return dataset.orderBy(col,cols);
    }

    @Transformal
    public static <T> Dataset<T> orderBy(Dataset<T> dataset,String col,String cols){
        String[] columns=cols.split(Consts.DELIMITER);
        return dataset.orderBy(col,columns);
    }

    @Transformal
    public static <T> Dataset<Row> select(Dataset<T> dataset,String col,String cols){
        String[] columns=cols.split(Consts.DELIMITER);
        return dataset.select(col,columns);
    }

    public static <T> Dataset<Row> select(Dataset<T> dataset,String col,String... cols){
        return dataset.select(col,cols);
    }

    public static <T> Dataset<Row> select(Dataset<T> dataset,String... exprs){
        return dataset.selectExpr(exprs);
    }

    @Transformal
    public static <T> Dataset<Row> select(Dataset<T> dataset,String exprs){
        String[] expressions=exprs.split(Consts.DELIMITER);
        return dataset.selectExpr(expressions);
    }

    @Transformal
    public static <T> Dataset<T> filter(Dataset<T> dataset,String expr){
        return dataset.filter(expr);
    }

    @Transformal
    public static <T> Dataset<T> where(Dataset<T> dataset,String expr){
        return dataset.where(expr);
    }

    public static <T> Dataset<Row> agg(Dataset<T> dataset,Map<String,String> map){
        return dataset.agg(map);
    }

    @Transformal
    public static <T> Dataset<T> limit(Dataset<T> dataset,int n){
        return dataset.limit(n);
    }

    public static <T> Dataset<T> intersect(Dataset<T> dataset1,Dataset<T> dataset2){
        return dataset1.intersect(dataset2);
    }

    public static <T> Dataset<T> except(Dataset<T> dataset1,Dataset<T> dataset2){
        return dataset1.except(dataset2);
    }

    @Transformal
    public static <T> Dataset<Row> withColumnRenamed(Dataset<T> dataset,String existingName,String newName){
        return dataset.withColumnRenamed(existingName,newName);
    }

    public static <T> Dataset<Row> drop(Dataset<T> dataset,String... cols){
        return dataset.drop(cols);
    }

    @Transformal
    public static <T> Dataset<T> dropDuplicates(Dataset<T> dataset){
        return dataset.dropDuplicates();
    }

    @Transformal
    public static <T> Dataset<T> dropDuplicates(Dataset<T> dataset,String cols){

        if(!Strings.isNullOrEmpty(cols)) {
            String[] columns=cols.split(Consts.DELIMITER);
            return dataset.dropDuplicates(columns);
        } else {
            return dataset.dropDuplicates();
        }
    }

    public static <T,U> Dataset<U> map(Dataset<T> dataset, MapFunction<T,U> func,Encoder<U> u){
        return dataset.map(func,u);
    }

    public static <T,U> Dataset<U> mapPartitions(Dataset<T> dataset, MapPartitionsFunction<T,U> func, Encoder<U> u){
        return dataset.mapPartitions(func,u);
    }

    public static <T,U> Dataset<U> flatMap(Dataset<T> dataset, FlatMapFunction<T,U> func, Encoder<U> u){
        return dataset.flatMap(func,u);
    }

    @Transformal
    public static <T> Dataset<T> repartition(Dataset<T> dataset,int n){
        return dataset.repartition(n);
    }

    @Transformal
    public static <T> Dataset<T> coalesce(Dataset<T> dataset,int n){
        return dataset.coalesce(n);
    }

    @Transformal
    public static <T> JavaRDD<T> toJavaRDD(Dataset<T> dataset){
        return dataset.toJavaRDD();
    }

    @Transformal
    public static <T> Dataset<String> toJSON(Dataset<T> dataset){
        return dataset.toJSON();
    }

    @Transformal
    public static <T> Dataset<Row> toDF(Dataset<T> dataset){
        return dataset.toDF();
    }

    public static <T> Dataset<Row> toDF(Dataset<T> dataset,String[] cols){
        return dataset.toDF(cols);
    }

    @Transformal
    public static <T> Dataset<Row> toDF(Dataset<T> dataset,String cols){
        String[] columns=cols.split(Consts.DELIMITER);
        return dataset.toDF(columns);
    }

    @Deprecated
    public static <T> Dataset<Row> cast(Dataset<T> dataset,String column, String type){
        String[] columns = column.split(Consts.DELIMITER);
        Dataset<Row> result = null;
        for (String c : columns) {

            if(result == null) {
                result = dataset.withColumn(c, dataset.col(c).cast(type));
            } else {
                result = result.withColumn(c, dataset.col(c).cast(type));
            }
        }
        return result == null ? dataset.toDF() : result;
    }

    public static void show(Dataset data, Integer numRows, Integer truncate) {
        if(numRows == null) {
            data.show();
        } else if(truncate == null){
            data.show(numRows);
        } else {
            data.show(numRows, truncate);
        }
    }
}
