package com.datastax.insight.ml.spark.data.rdd;

import com.datastax.insight.spec.RDDOperator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.storage.StorageLevel;

public class RDDWriter implements RDDOperator {
    public static <T> void cache(JavaRDD<T> rdd){
        rdd.cache();
    }

    public static <T> void persist(JavaRDD<T> rdd,String storageLevel){
        StorageLevel level=StorageLevel.fromString(storageLevel);
        rdd.persist(level);
    }

    public static <T> void unpersist(JavaRDD<T> rdd,boolean blocking){
        rdd.unpersist(blocking);
    }

    public static <T> void saveFile(JavaRDD<T> rdd,String format,String path){
        if(format.equals("object")){
            rdd.saveAsObjectFile(path);
        }else if(format.equals("text")){
            rdd.saveAsTextFile(path);
        }
    }

    public static <T> void checkpoint(JavaRDD<T> rdd){
        rdd.checkpoint();
    }

}
