package com.datastax.insight.ml.spark.hive;

import com.datastax.insight.spec.DataSetOperator;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class HiveHandler implements DataSetOperator {
    public static Dataset<Row> hsql(String... hql){
        SparkSession spark = SparkSession
                .builder()
                .appName("datastax-Insight Hive Operator")
                .getOrCreate();

        Dataset<Row> result = null;

        for(String sql : hql){
            result = spark.sql(sql);
        }

        return result;
    }

    public static Dataset<Row> hsql(String hql){
        String[] sql = hql.split(";");
        return hsql(sql);
    }
}
