package com.datastax.insight.ml.spark.ml.feature.transformer;

import com.datastax.insight.spec.DataSetOperator;
import org.apache.spark.ml.feature.Binarizer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

/**
 * 二值化
 */
public class BinarizerWrapper implements DataSetOperator {
    /**
     * 二值化转换器
     */
    public static Binarizer getOperator(String inputCol, String outputCol,double threshold){
        Binarizer binarizer = new Binarizer()
                .setInputCol(inputCol)
                .setOutputCol(outputCol)
                .setThreshold(threshold);
        return binarizer;
    }

    public static Dataset<Row> transform(Dataset<Row> data, String inputCol, String outputCol,double threshold){
        Binarizer binarizer=getOperator(inputCol,outputCol,threshold);
        Dataset<Row> tdata=binarizer.transform(data);
        return tdata;
    }

    /**
     * 二值化转换
     */
    public static Dataset<Row> transform(Binarizer binarizer,Dataset<Row> data){
        Dataset<Row> tdata=binarizer.transform(data);
        return tdata;
    }
}
