package com.datastax.insight.ml.spark.ml.feature.transformer;

import com.datastax.insight.spec.DataSetOperator;
import org.apache.spark.ml.feature.DCT;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

/**
 * 离散余弦
 */
public class DCTWrapper implements DataSetOperator {
    /**
     * 离散余弦变换器
     */
    public static DCT getOperator(String inputCol, String outputCol, boolean inverse){
        DCT dct = new DCT()
                .setInputCol(inputCol)
                .setOutputCol(outputCol)
                .setInverse(inverse);
        return dct;
    }

    public static Dataset<Row> transform(Dataset<Row> data, String inputCol, String outputCol, boolean inverse){
        DCT dct=getOperator(inputCol,outputCol,inverse);
        Dataset<Row> tdata=dct.transform(data);
        return tdata;
    }

    /**
     * 离散余弦变换
     */
    public static Dataset<Row> transform(DCT dct,Dataset<Row> data){
        Dataset<Row> tdata=dct.transform(data);
        return tdata;
    }
}
