package com.datastax.insight.ml.spark.ml.feature.transformer;

import com.datastax.insight.spec.DataSetOperator;
import org.apache.spark.ml.feature.MaxAbsScaler;
import org.apache.spark.ml.feature.MaxAbsScalerModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

/**
 * 绝对值最大标准化
 */
public class MaxAbsScalerWrapper implements DataSetOperator {
    /**
     * 绝对值最大标准化转换器
     */
    public static MaxAbsScaler getOperator(String inputCol, String outputCol){
        MaxAbsScaler minMaxScaler = new MaxAbsScaler()
                .setInputCol(inputCol)
                .setOutputCol(outputCol);
        return minMaxScaler;
    }

    public static MaxAbsScalerModel fit(Dataset<Row> data, String inputCol, String outputCol){
        MaxAbsScaler minMaxScaler=getOperator(inputCol,outputCol);
        MaxAbsScalerModel model =minMaxScaler.fit(data);
        return model;
    }

    /**
     * 绝对值最大标准化模型训练
     */
    public static MaxAbsScalerModel fit(MaxAbsScaler minMaxScaler,Dataset<Row> data){
        MaxAbsScalerModel model =minMaxScaler.fit(data);
        return model;
    }

    /**
     * 绝对值最大标准化转换
     */
    public static Dataset<Row> transform(MaxAbsScalerModel model, Dataset<Row> data){
        Dataset<Row> tdata=model.transform(data);
        return tdata;
    }
}
