package com.datastax.insight.ml.spark.ml.feature.transformer;

import com.datastax.insight.spec.DataSetOperator;
import org.apache.spark.ml.feature.NGram;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class NGramWrapper implements DataSetOperator {
    public static NGram getOperator(String inputCol, String outputCol,int n){
        NGram nGram = new NGram()
                .setInputCol(inputCol).setN(n)
                .setOutputCol(outputCol);
        return nGram;
    }

    public static Dataset<Row> transform(Dataset<Row> data, String inputCol, String outputCol,int n){
        NGram nGram=getOperator(inputCol,outputCol,n);
        Dataset<Row> tdata=nGram.transform(data);
        return tdata;
    }

    public static Dataset<Row> transform(NGram nGram,Dataset<Row> data){
        Dataset<Row> tdata=nGram.transform(data);
        return tdata;
    }
}
