package com.datastax.insight.ml.spark.ml.feature.transformer;

import com.datastax.insight.spec.DataSetOperator;
import org.apache.spark.ml.feature.Normalizer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

/**
 * 归一化
 */
public class NormalizerWrapper implements DataSetOperator {
    /**
     * 归一化转换器
     */
    public static Normalizer getOperator(String inputCol, String outputCol,double p){
        Normalizer normalizer = new Normalizer()
                .setInputCol(inputCol)
                .setOutputCol(outputCol)
                .setP(p);
        return normalizer;
    }

    public static Dataset<Row> transform(Dataset<Row> data, String inputCol, String outputCol,double p){
        Normalizer normalizer=getOperator(inputCol,outputCol,p);
        Dataset<Row> tdata=normalizer.transform(data);
        return tdata;
    }

    /**
     * 归一化转换
     */
    public static Dataset<Row> transform(Normalizer normalizer,Dataset<Row> data){
        Dataset<Row> tdata=normalizer.transform(data);
        return tdata;
    }
}
