package com.datastax.insight.ml.spark.ml.feature.transformer;

import com.datastax.insight.spec.DataSetOperator;
import org.apache.spark.ml.feature.PolynomialExpansion;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

/**
 * 多项式展开
 */
public class PolynomialExpansionWrapper implements DataSetOperator {
    /**
     * 多项式展开器
     */
    public static PolynomialExpansion getOperator(String inputCol, String outputCol, int degree){
        PolynomialExpansion polynomialExpansion = new PolynomialExpansion()
                .setInputCol(inputCol)
                .setOutputCol(outputCol)
                .setDegree(degree);
        return polynomialExpansion;
    }

    public static Dataset<Row> transform(Dataset<Row> data, String inputCol, String outputCol, int degree){
        PolynomialExpansion polynomialExpansion=getOperator(inputCol,outputCol,degree);
        Dataset<Row> tdata=polynomialExpansion.transform(data);
        return tdata;
    }

    /**
     * 多项式展开变换
     */
    public static Dataset<Row> transform(PolynomialExpansion polynomialExpansion,Dataset<Row> data){
        Dataset<Row> tdata=polynomialExpansion.transform(data);
        return tdata;
    }
}
