package com.datastax.insight.ml.spark.ml.regression;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.regression.IsotonicRegression;
import org.apache.spark.ml.regression.IsotonicRegressionModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

/**
 * 保序回归
 */
public class IsotonicRegressionWrapper implements DataSetOperator {

    public static IsotonicRegression getOperator(String labelCol,
                                                 String featureCol,
                                                 String predictionCol,
                                                 Boolean isotonic,
                                                 String weightCol,
                                                 Integer featureIndex) {

        IsotonicRegression regressor = new IsotonicRegression();

        if (!Strings.isNullOrEmpty(labelCol)) {
            regressor.setLabelCol(labelCol);
        }

        if (!Strings.isNullOrEmpty(featureCol)) {
            regressor.setFeaturesCol(featureCol);
        }

        if (!Strings.isNullOrEmpty(predictionCol)) {
            regressor.setPredictionCol(predictionCol);
        }

        if (isotonic != null) {
            regressor.setIsotonic(isotonic);
        }

        if (!Strings.isNullOrEmpty(weightCol)) {
            regressor.setWeightCol(weightCol);
        }

        if (featureIndex != null) {
            regressor.setFeatureIndex(featureIndex);
        }

        return regressor;
    }

    public static IsotonicRegressionModel fit(Dataset<Row> data,
                                              String labelCol,
                                              String featureCol,
                                              String predictionCol,
                                              Boolean isotonic,
                                              String weightCol,
                                              Integer featureIndex) {

        IsotonicRegression regressor = getOperator(labelCol,
                featureCol,
                predictionCol,
                isotonic,
                weightCol,
                featureIndex);
        return regressor.fit(data);
    }

    public static IsotonicRegressionModel fit(IsotonicRegression regressor, Dataset<Row> data) {
        return regressor.fit(data);
    }

    public static Dataset<Row> transform(IsotonicRegressionModel model, Dataset<Row> data) {
        return model.transform(data);
    }
}
