package com.datastax.insight.ml.spark.mllib.cluster;

import com.datastax.insight.spec.RDDOperator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.clustering.BisectingKMeans;
import org.apache.spark.mllib.clustering.BisectingKMeansModel;
import org.apache.spark.mllib.linalg.Vector;

public class BisectingKMeansHandler implements RDDOperator {
    public static BisectingKMeansModel train(JavaRDD<Vector> vectors, int numCLusters){
        return new BisectingKMeans().setK(numCLusters).run(vectors);
    }
}
