package com.datastax.insight.ml.spark.mllib.cluster;

import com.datastax.insight.spec.RDDOperator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.clustering.GaussianMixture;
import org.apache.spark.mllib.clustering.GaussianMixtureModel;
import org.apache.spark.mllib.linalg.Vector;

//混合高斯
public class GaussianMixturer implements RDDOperator {
    public static GaussianMixtureModel train(JavaRDD<Vector> data, int numClasses,
                                             long seed,int maxIterations){
        GaussianMixtureModel model=new GaussianMixture().setK(numClasses)
                .setSeed(seed).setMaxIterations(maxIterations).run(data);
        return model;
    }
}
