package com.datastax.insight.ml.spark.mllib.feature;

import com.datastax.insight.spec.RDDOperator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.Normalizer;
import org.apache.spark.mllib.linalg.Vector;

public class FeatureNormalizer implements RDDOperator {
    public static JavaRDD<Vector> transformRDD(JavaRDD<Vector> data,double p){
        Normalizer normalizer=new Normalizer(p);
        JavaRDD<Vector> nData=normalizer.transform(data);
        return nData;
    }

    public static Vector transformVector(Vector vector,double p){
        Normalizer normalizer=new Normalizer(p);
        Vector nData=normalizer.transform(vector);
        return nData;
    }
}
