package com.datastax.insight.ml.spark.mllib.feature;

import com.datastax.insight.spec.RDDOperator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.StandardScaler;
import org.apache.spark.mllib.feature.StandardScalerModel;
import org.apache.spark.mllib.linalg.Vector;

public class FeatureStandardScaler implements RDDOperator {
    public static JavaRDD< Vector> transform(JavaRDD< Vector> data,boolean withMean,boolean withStd){
        StandardScaler scaler=new StandardScaler(withMean,withStd);
        StandardScalerModel model=scaler.fit(data.rdd());
        return model.transform(data);
    }
}
