package com.datastax.insight.ml.spark.mllib.recommendation.als;

import com.datastax.insight.spec.RDDOperator;
import com.datastax.insight.ml.spark.data.rdd.RDDConverter;
import com.datastax.insight.ml.spark.data.rdd.RDDLoader;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.recommendation.Rating;

public class RatingRDDLoader implements RDDOperator {
    private final static String DELIMITER="::";
    private final static String[] PROP_ORDERS=new String[]{"user","product","rating"};

    public static JavaRDD<Rating> fromTextFile(String path){
        return fromTextFile(path,DELIMITER,PROP_ORDERS);
    }

    public static JavaRDD<Rating> fromTextFile(String path,String delimiter,String[] propOrders){
        JavaRDD<Rating> rdd= RDDLoader.load(path, new RDDConverter() {
            @Override
            public Rating convert(String line) {
                String[] tok = line.split(delimiter);
                int[] orders=new int[PROP_ORDERS.length];
                for(int i=0;i<PROP_ORDERS.length;i++){
                    for(int j=0;j<propOrders.length;j++){
                        if(PROP_ORDERS[i].equals(propOrders[j])){
                            orders[i]=j;
                        }
                    }
                }
                int x = Integer.parseInt(tok[orders[0]]);
                int y = Integer.parseInt(tok[orders[1]]);
                double rating = Double.parseDouble(tok[orders[2]]);
                return new Rating(x, y, rating);
            }
        });
        return rdd;
    }

    public static JavaRDD<Rating> fromTextFile(String path,String delimiter,String propList){
        String[] propOrders=null;
        if(propList!=null) propOrders=propList.split(",");

        if(delimiter==null) delimiter=DELIMITER;
        if(propOrders==null) propOrders=PROP_ORDERS;
        return fromTextFile(path,delimiter,propOrders);
    }

}
