package com.datastax.insight.ml.spark.mllib.regression;

import com.datastax.insight.spec.RDDOperator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import scala.Tuple2;

import java.util.HashMap;
import java.util.Map;

public class DecisionTreeRegression implements RDDOperator {
    public static DecisionTreeModel train(JavaRDD<LabeledPoint> data,
                                          int maxDepth, int maxBins){
       return train(data,"variance",maxDepth,maxBins);
    }

    public static DecisionTreeModel train(JavaRDD<LabeledPoint> data,
                                          String impurity, int maxDepth, int maxBins){
        Map<Integer, Integer> categoricalFeaturesInfo = new HashMap<>();
        DecisionTreeModel model = DecisionTree.trainRegressor(data,
                categoricalFeaturesInfo, impurity, maxDepth, maxBins);
        return model;
    }

    public static JavaPairRDD<Double, Double> predict(JavaRDD<LabeledPoint> data, DecisionTreeModel model){
        JavaPairRDD<Double, Double> predictionAndLabel =
                data.mapToPair(new PairFunction<LabeledPoint, Double, Double>() {
                    @Override
                    public Tuple2<Double, Double> call(LabeledPoint p) {
                        return new Tuple2<>(model.predict(p.features()), p.label());
                    }
                });
        return predictionAndLabel;
    }
}
