/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPObject;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.parser.deserializer.ASMDeserializerFactory;
import com.alibaba.fastjson.parser.deserializer.ArrayListTypeFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.AutowiredObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.DefaultFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.EnumDeserializer;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.JSONPDeserializer;
import com.alibaba.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.deserializer.JavaObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.Jdk8DateCodec;
import com.alibaba.fastjson.parser.deserializer.MapDeserializer;
import com.alibaba.fastjson.parser.deserializer.NumberDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.OptionalCodec;
import com.alibaba.fastjson.parser.deserializer.SqlDateDeserializer;
import com.alibaba.fastjson.parser.deserializer.StackTraceElementDeserializer;
import com.alibaba.fastjson.parser.deserializer.ThrowableDeserializer;
import com.alibaba.fastjson.parser.deserializer.TimeDeserializer;
import com.alibaba.fastjson.serializer.AtomicCodec;
import com.alibaba.fastjson.serializer.AwtCodec;
import com.alibaba.fastjson.serializer.BigDecimalCodec;
import com.alibaba.fastjson.serializer.BigIntegerCodec;
import com.alibaba.fastjson.serializer.BooleanCodec;
import com.alibaba.fastjson.serializer.CalendarCodec;
import com.alibaba.fastjson.serializer.CharArrayCodec;
import com.alibaba.fastjson.serializer.CharacterCodec;
import com.alibaba.fastjson.serializer.CollectionCodec;
import com.alibaba.fastjson.serializer.DateCodec;
import com.alibaba.fastjson.serializer.FloatCodec;
import com.alibaba.fastjson.serializer.IntegerCodec;
import com.alibaba.fastjson.serializer.LongCodec;
import com.alibaba.fastjson.serializer.MiscCodec;
import com.alibaba.fastjson.serializer.ObjectArrayCodec;
import com.alibaba.fastjson.serializer.ReferenceCodec;
import com.alibaba.fastjson.serializer.StringCodec;
import com.alibaba.fastjson.util.ASMClassLoader;
import com.alibaba.fastjson.util.ASMUtils;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.IOUtils;
import com.alibaba.fastjson.util.IdentityHashMap;
import com.alibaba.fastjson.util.JavaBeanInfo;
import com.alibaba.fastjson.util.ServiceLoader;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import javax.xml.datatype.XMLGregorianCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserConfig {
    public static final String DENY_PROPERTY = "fastjson.parser.deny";
    public static final String AUTOTYPE_ACCEPT = "fastjson.parser.autoTypeAccept";
    public static final String AUTOTYPE_SUPPORT_PROPERTY = "fastjson.parser.autoTypeSupport";
    public static final String[] DENYS;
    private static final String[] AUTO_TYPE_ACCEPT_LIST;
    public static final boolean AUTO_SUPPORT;
    public static ParserConfig global;
    private final IdentityHashMap<Type, ObjectDeserializer> deserializers = new IdentityHashMap();
    private boolean asmEnable = !ASMUtils.IS_ANDROID;
    public final SymbolTable symbolTable = new SymbolTable(4096);
    public PropertyNamingStrategy propertyNamingStrategy;
    protected ClassLoader defaultClassLoader;
    protected ASMDeserializerFactory asmFactory;
    private static boolean awtError;
    private static boolean jdk8Error;
    private boolean autoTypeSupport = AUTO_SUPPORT;
    private String[] denyList = "bsh,com.mchange,com.sun.,java.lang.Thread,java.net.Socket,java.rmi,javax.xml,org.apache.bcel,org.apache.commons.beanutils,org.apache.commons.collections.Transformer,org.apache.commons.collections.functors,org.apache.commons.collections4.comparators,org.apache.commons.fileupload,org.apache.myfaces.context.servlet,org.apache.tomcat,org.apache.wicket.util,org.codehaus.groovy.runtime,org.hibernate,org.jboss,org.mozilla.javascript,org.python.core,org.springframework".split(",");
    private String[] acceptList = AUTO_TYPE_ACCEPT_LIST;
    private int maxTypeNameLength = 256;

    public static ParserConfig getGlobalInstance() {
        return global;
    }

    public ParserConfig() {
        this(null, null);
    }

    public ParserConfig(ClassLoader parentClassLoader) {
        this(null, parentClassLoader);
    }

    public ParserConfig(ASMDeserializerFactory asmFactory) {
        this(asmFactory, null);
    }

    private ParserConfig(ASMDeserializerFactory asmFactory, ClassLoader parentClassLoader) {
        if (asmFactory == null && !ASMUtils.IS_ANDROID) {
            try {
                asmFactory = parentClassLoader == null ? new ASMDeserializerFactory(new ASMClassLoader()) : new ASMDeserializerFactory(parentClassLoader);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
            }
            catch (AccessControlException accessControlException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        this.asmFactory = asmFactory;
        if (asmFactory == null) {
            this.asmEnable = false;
        }
        this.deserializers.put((Type)((Object)SimpleDateFormat.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Timestamp.class), SqlDateDeserializer.instance_timestamp);
        this.deserializers.put((Type)((Object)java.sql.Date.class), SqlDateDeserializer.instance);
        this.deserializers.put((Type)((Object)Time.class), TimeDeserializer.instance);
        this.deserializers.put((Type)((Object)Date.class), DateCodec.instance);
        this.deserializers.put((Type)((Object)Calendar.class), CalendarCodec.instance);
        this.deserializers.put((Type)((Object)XMLGregorianCalendar.class), CalendarCodec.instance);
        this.deserializers.put((Type)((Object)JSONObject.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)JSONArray.class), CollectionCodec.instance);
        this.deserializers.put((Type)((Object)Map.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)HashMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)LinkedHashMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)TreeMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)ConcurrentMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)ConcurrentHashMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)Collection.class), CollectionCodec.instance);
        this.deserializers.put((Type)((Object)List.class), CollectionCodec.instance);
        this.deserializers.put((Type)((Object)ArrayList.class), CollectionCodec.instance);
        this.deserializers.put((Type)((Object)Object.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)String.class), StringCodec.instance);
        this.deserializers.put((Type)((Object)StringBuffer.class), StringCodec.instance);
        this.deserializers.put((Type)((Object)StringBuilder.class), StringCodec.instance);
        this.deserializers.put(Character.TYPE, CharacterCodec.instance);
        this.deserializers.put((Type)((Object)Character.class), CharacterCodec.instance);
        this.deserializers.put(Byte.TYPE, NumberDeserializer.instance);
        this.deserializers.put((Type)((Object)Byte.class), NumberDeserializer.instance);
        this.deserializers.put(Short.TYPE, NumberDeserializer.instance);
        this.deserializers.put((Type)((Object)Short.class), NumberDeserializer.instance);
        this.deserializers.put(Integer.TYPE, IntegerCodec.instance);
        this.deserializers.put((Type)((Object)Integer.class), IntegerCodec.instance);
        this.deserializers.put(Long.TYPE, LongCodec.instance);
        this.deserializers.put((Type)((Object)Long.class), LongCodec.instance);
        this.deserializers.put((Type)((Object)BigInteger.class), BigIntegerCodec.instance);
        this.deserializers.put((Type)((Object)BigDecimal.class), BigDecimalCodec.instance);
        this.deserializers.put(Float.TYPE, FloatCodec.instance);
        this.deserializers.put((Type)((Object)Float.class), FloatCodec.instance);
        this.deserializers.put(Double.TYPE, NumberDeserializer.instance);
        this.deserializers.put((Type)((Object)Double.class), NumberDeserializer.instance);
        this.deserializers.put(Boolean.TYPE, BooleanCodec.instance);
        this.deserializers.put((Type)((Object)Boolean.class), BooleanCodec.instance);
        this.deserializers.put((Type)((Object)Class.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)char[].class), new CharArrayCodec());
        this.deserializers.put((Type)((Object)AtomicBoolean.class), BooleanCodec.instance);
        this.deserializers.put((Type)((Object)AtomicInteger.class), IntegerCodec.instance);
        this.deserializers.put((Type)((Object)AtomicLong.class), LongCodec.instance);
        this.deserializers.put((Type)((Object)AtomicReference.class), ReferenceCodec.instance);
        this.deserializers.put((Type)((Object)WeakReference.class), ReferenceCodec.instance);
        this.deserializers.put((Type)((Object)SoftReference.class), ReferenceCodec.instance);
        this.deserializers.put((Type)((Object)UUID.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)TimeZone.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Locale.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Currency.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)InetAddress.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Inet4Address.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Inet6Address.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)InetSocketAddress.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)File.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)URI.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)URL.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Pattern.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Charset.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)JSONPath.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Number.class), NumberDeserializer.instance);
        this.deserializers.put((Type)((Object)AtomicIntegerArray.class), AtomicCodec.instance);
        this.deserializers.put((Type)((Object)AtomicLongArray.class), AtomicCodec.instance);
        this.deserializers.put((Type)((Object)StackTraceElement.class), StackTraceElementDeserializer.instance);
        this.deserializers.put((Type)((Object)Serializable.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)Cloneable.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)Comparable.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)Closeable.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)JSONPObject.class), new JSONPDeserializer());
        this.addItemsToDeny(DENYS);
        this.addItemsToAccept(AUTO_TYPE_ACCEPT_LIST);
    }

    private static String[] splitItemsFormProperty(String property) {
        if (property != null && property.length() > 0) {
            return property.split(",");
        }
        return null;
    }

    public void configFromPropety(Properties properties) {
        String property = properties.getProperty(DENY_PROPERTY);
        String[] items = ParserConfig.splitItemsFormProperty(property);
        this.addItemsToDeny(items);
        property = properties.getProperty(AUTOTYPE_ACCEPT);
        items = ParserConfig.splitItemsFormProperty(property);
        this.addItemsToAccept(items);
        property = properties.getProperty(AUTOTYPE_SUPPORT_PROPERTY);
        if ("true".equals(property)) {
            this.autoTypeSupport = true;
        } else if ("false".equals(property)) {
            this.autoTypeSupport = false;
        }
    }

    private void addItemsToDeny(String[] items) {
        if (items == null) {
            return;
        }
        for (int i2 = 0; i2 < items.length; ++i2) {
            String item = items[i2];
            this.addDeny(item);
        }
    }

    private void addItemsToAccept(String[] items) {
        if (items == null) {
            return;
        }
        for (int i2 = 0; i2 < items.length; ++i2) {
            String item = items[i2];
            this.addAccept(item);
        }
    }

    public boolean isAutoTypeSupport() {
        return this.autoTypeSupport;
    }

    public void setAutoTypeSupport(boolean autoTypeSupport) {
        this.autoTypeSupport = autoTypeSupport;
    }

    public boolean isAsmEnable() {
        return this.asmEnable;
    }

    public void setAsmEnable(boolean asmEnable) {
        this.asmEnable = asmEnable;
    }

    public IdentityHashMap<Type, ObjectDeserializer> getDeserializers() {
        return this.deserializers;
    }

    public ObjectDeserializer getDeserializer(Type type) {
        ObjectDeserializer derializer = this.deserializers.get(type);
        if (derializer != null) {
            return derializer;
        }
        if (type instanceof Class) {
            return this.getDeserializer((Class)type, type);
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType instanceof Class) {
                return this.getDeserializer((Class)rawType, type);
            }
            return this.getDeserializer(rawType);
        }
        return JavaObjectDeserializer.instance;
    }

    public ObjectDeserializer getDeserializer(Class<?> clazz, Type type) {
        Class<?> mappingTo;
        ObjectDeserializer derializer = this.deserializers.get(type);
        if (derializer != null) {
            return derializer;
        }
        if (type == null) {
            type = clazz;
        }
        if ((derializer = this.deserializers.get(type)) != null) {
            return derializer;
        }
        JSONType annotation = clazz.getAnnotation(JSONType.class);
        if (annotation != null && (mappingTo = annotation.mappingTo()) != Void.class) {
            return this.getDeserializer(mappingTo, mappingTo);
        }
        if (type instanceof WildcardType || type instanceof TypeVariable || type instanceof ParameterizedType) {
            derializer = this.deserializers.get(clazz);
        }
        if (derializer != null) {
            return derializer;
        }
        String className = clazz.getName();
        if ((className = className.replace('$', '.')).startsWith("java.awt.") && AwtCodec.support(clazz) && !awtError) {
            try {
                this.deserializers.put(Class.forName("java.awt.Point"), AwtCodec.instance);
                this.deserializers.put(Class.forName("java.awt.Font"), AwtCodec.instance);
                this.deserializers.put(Class.forName("java.awt.Rectangle"), AwtCodec.instance);
                this.deserializers.put(Class.forName("java.awt.Color"), AwtCodec.instance);
            }
            catch (Throwable e2) {
                awtError = true;
            }
            derializer = AwtCodec.instance;
        }
        if (!jdk8Error) {
            try {
                if (className.startsWith("java.time.")) {
                    this.deserializers.put(Class.forName("java.time.LocalDateTime"), Jdk8DateCodec.instance);
                    this.deserializers.put(Class.forName("java.time.LocalDate"), Jdk8DateCodec.instance);
                    this.deserializers.put(Class.forName("java.time.LocalTime"), Jdk8DateCodec.instance);
                    this.deserializers.put(Class.forName("java.time.ZonedDateTime"), Jdk8DateCodec.instance);
                    this.deserializers.put(Class.forName("java.time.OffsetDateTime"), Jdk8DateCodec.instance);
                    this.deserializers.put(Class.forName("java.time.OffsetTime"), Jdk8DateCodec.instance);
                    this.deserializers.put(Class.forName("java.time.ZoneOffset"), Jdk8DateCodec.instance);
                    this.deserializers.put(Class.forName("java.time.ZoneRegion"), Jdk8DateCodec.instance);
                    this.deserializers.put(Class.forName("java.time.ZoneId"), Jdk8DateCodec.instance);
                    this.deserializers.put(Class.forName("java.time.Period"), Jdk8DateCodec.instance);
                    this.deserializers.put(Class.forName("java.time.Duration"), Jdk8DateCodec.instance);
                    this.deserializers.put(Class.forName("java.time.Instant"), Jdk8DateCodec.instance);
                    derializer = this.deserializers.get(clazz);
                } else if (className.startsWith("java.util.Optional")) {
                    this.deserializers.put(Class.forName("java.util.Optional"), OptionalCodec.instance);
                    this.deserializers.put(Class.forName("java.util.OptionalDouble"), OptionalCodec.instance);
                    this.deserializers.put(Class.forName("java.util.OptionalInt"), OptionalCodec.instance);
                    this.deserializers.put(Class.forName("java.util.OptionalLong"), OptionalCodec.instance);
                    derializer = this.deserializers.get(clazz);
                }
            }
            catch (Throwable e3) {
                jdk8Error = true;
            }
        }
        if (className.equals("java.nio.file.Path")) {
            this.deserializers.put(clazz, MiscCodec.instance);
        }
        if (clazz == Map.Entry.class) {
            this.deserializers.put(clazz, MiscCodec.instance);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            for (AutowiredObjectDeserializer autowired : ServiceLoader.load(AutowiredObjectDeserializer.class, classLoader)) {
                for (Type forType : autowired.getAutowiredFor()) {
                    this.deserializers.put(forType, autowired);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (derializer == null) {
            derializer = this.deserializers.get(type);
        }
        if (derializer != null) {
            return derializer;
        }
        derializer = clazz.isEnum() ? new EnumDeserializer(clazz) : (clazz.isArray() ? ObjectArrayCodec.instance : (clazz == Set.class || clazz == HashSet.class || clazz == Collection.class || clazz == List.class || clazz == ArrayList.class ? CollectionCodec.instance : (Collection.class.isAssignableFrom(clazz) ? CollectionCodec.instance : (Map.class.isAssignableFrom(clazz) ? MapDeserializer.instance : (Throwable.class.isAssignableFrom(clazz) ? new ThrowableDeserializer(this, clazz) : this.createJavaBeanDeserializer(clazz, type))))));
        this.putDeserializer(type, derializer);
        return derializer;
    }

    public void initJavaBeanDeserializers(Class<?> ... classes) {
        if (classes == null) {
            return;
        }
        for (Class<?> type : classes) {
            if (type == null) continue;
            ObjectDeserializer deserializer = this.createJavaBeanDeserializer(type, type);
            this.putDeserializer(type, deserializer);
        }
    }

    public ObjectDeserializer createJavaBeanDeserializer(Class<?> clazz, Type type) {
        JavaBeanInfo beanInfo;
        boolean asmEnable = this.asmEnable;
        if (asmEnable) {
            JSONType jsonType = clazz.getAnnotation(JSONType.class);
            if (jsonType != null) {
                Class<?> deserializerClass = jsonType.deserializer();
                if (deserializerClass != Void.class) {
                    try {
                        Object deseralizer = deserializerClass.newInstance();
                        if (deseralizer instanceof ObjectDeserializer) {
                            return (ObjectDeserializer)deseralizer;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                asmEnable = jsonType.asm();
            }
            if (asmEnable) {
                Class<?> superClass = JavaBeanInfo.getBuilderClass(jsonType);
                if (superClass == null) {
                    superClass = clazz;
                }
                do {
                    if (Modifier.isPublic(superClass.getModifiers())) continue;
                    asmEnable = false;
                    break;
                } while ((superClass = superClass.getSuperclass()) != Object.class && superClass != null);
            }
        }
        if (clazz.getTypeParameters().length != 0) {
            asmEnable = false;
        }
        if (asmEnable && this.asmFactory != null && this.asmFactory.classLoader.isExternalClass(clazz)) {
            asmEnable = false;
        }
        if (asmEnable) {
            asmEnable = ASMUtils.checkName(clazz.getSimpleName());
        }
        if (asmEnable) {
            if (clazz.isInterface()) {
                asmEnable = false;
            }
            beanInfo = JavaBeanInfo.build(clazz, type, this.propertyNamingStrategy);
            if (asmEnable && beanInfo.fields.length > 200) {
                asmEnable = false;
            }
            Constructor<?> defaultConstructor = beanInfo.defaultConstructor;
            if (asmEnable && defaultConstructor == null && !clazz.isInterface()) {
                asmEnable = false;
            }
            for (FieldInfo fieldInfo : beanInfo.fields) {
                ObjectDeserializer fieldDeser;
                if (fieldInfo.getOnly) {
                    asmEnable = false;
                    break;
                }
                Class<?> fieldClass = fieldInfo.fieldClass;
                if (!Modifier.isPublic(fieldClass.getModifiers())) {
                    asmEnable = false;
                    break;
                }
                if (fieldClass.isMemberClass() && !Modifier.isStatic(fieldClass.getModifiers())) {
                    asmEnable = false;
                    break;
                }
                if (fieldInfo.getMember() != null && !ASMUtils.checkName(fieldInfo.getMember().getName())) {
                    asmEnable = false;
                    break;
                }
                JSONField annotation = fieldInfo.getAnnotation();
                if (!(annotation == null || ASMUtils.checkName(annotation.name()) && annotation.format().length() == 0 && annotation.deserializeUsing() == Void.class)) {
                    asmEnable = false;
                    break;
                }
                if (!fieldClass.isEnum() || (fieldDeser = this.getDeserializer(fieldClass)) instanceof EnumDeserializer) continue;
                asmEnable = false;
                break;
            }
        }
        if (asmEnable && clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
            asmEnable = false;
        }
        if (!asmEnable) {
            return new JavaBeanDeserializer(this, clazz, type);
        }
        beanInfo = JavaBeanInfo.build(clazz, type, this.propertyNamingStrategy);
        try {
            return this.asmFactory.createJavaBeanDeserializer(this, beanInfo);
        }
        catch (NoSuchMethodException ex) {
            return new JavaBeanDeserializer(this, clazz, type);
        }
        catch (JSONException asmError) {
            return new JavaBeanDeserializer(this, beanInfo);
        }
        catch (Exception e2) {
            throw new JSONException("create asm deserializer error, " + clazz.getName(), e2);
        }
    }

    public FieldDeserializer createFieldDeserializer(ParserConfig mapping, JavaBeanInfo beanInfo, FieldInfo fieldInfo) {
        Class<?> clazz = beanInfo.clazz;
        Class<?> fieldClass = fieldInfo.fieldClass;
        Class<?> deserializeUsing = null;
        JSONField annotation = fieldInfo.getAnnotation();
        if (annotation != null && (deserializeUsing = annotation.deserializeUsing()) == Void.class) {
            deserializeUsing = null;
        }
        if (deserializeUsing == null && (fieldClass == List.class || fieldClass == ArrayList.class)) {
            return new ArrayListTypeFieldDeserializer(mapping, clazz, fieldInfo);
        }
        return new DefaultFieldDeserializer(mapping, clazz, fieldInfo);
    }

    public void putDeserializer(Type type, ObjectDeserializer deserializer) {
        this.deserializers.put(type, deserializer);
    }

    public ObjectDeserializer getDeserializer(FieldInfo fieldInfo) {
        return this.getDeserializer(fieldInfo.fieldClass, fieldInfo.fieldType);
    }

    public boolean isPrimitive(Class<?> clazz) {
        return ParserConfig.isPrimitive2(clazz);
    }

    public static boolean isPrimitive2(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == Boolean.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == BigInteger.class || clazz == BigDecimal.class || clazz == String.class || clazz == Date.class || clazz == java.sql.Date.class || clazz == Time.class || clazz == Timestamp.class || clazz.isEnum();
    }

    public static void parserAllFieldToCache(Class<?> clazz, Map<String, Field> fieldCacheMap) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            String fieldName = field.getName();
            if (fieldCacheMap.containsKey(fieldName)) continue;
            fieldCacheMap.put(fieldName, field);
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            ParserConfig.parserAllFieldToCache(clazz.getSuperclass(), fieldCacheMap);
        }
    }

    public static Field getFieldFromCache(String fieldName, Map<String, Field> fieldCacheMap) {
        Field field = fieldCacheMap.get(fieldName);
        if (field == null) {
            field = fieldCacheMap.get("_" + fieldName);
        }
        if (field == null) {
            field = fieldCacheMap.get("m_" + fieldName);
        }
        return field;
    }

    public ClassLoader getDefaultClassLoader() {
        return this.defaultClassLoader;
    }

    public void setDefaultClassLoader(ClassLoader defaultClassLoader) {
        this.defaultClassLoader = defaultClassLoader;
    }

    public void addDeny(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        for (String item : this.denyList) {
            if (!name.equals(item)) continue;
            return;
        }
        String[] denyList = new String[this.denyList.length + 1];
        System.arraycopy(this.denyList, 0, denyList, 0, this.denyList.length);
        denyList[denyList.length - 1] = name;
        this.denyList = denyList;
    }

    public void addAccept(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        for (String item : this.acceptList) {
            if (!name.equals(item)) continue;
            return;
        }
        String[] acceptList = new String[this.acceptList.length + 1];
        System.arraycopy(this.acceptList, 0, acceptList, 0, this.acceptList.length);
        acceptList[acceptList.length - 1] = name;
        this.acceptList = acceptList;
    }

    public Class<?> checkAutoType(String typeName, Class<?> expectClass) {
        Class<?> clazz;
        if (typeName == null) {
            return null;
        }
        if (typeName.length() >= this.maxTypeNameLength) {
            throw new JSONException("autoType is not support. " + typeName);
        }
        String className = typeName.replace('$', '.');
        if (this.autoTypeSupport || expectClass != null) {
            int i2;
            for (i2 = 0; i2 < this.acceptList.length; ++i2) {
                String accept = this.acceptList[i2];
                if (!className.startsWith(accept)) continue;
                return TypeUtils.loadClass(typeName, this.defaultClassLoader);
            }
            for (i2 = 0; i2 < this.denyList.length; ++i2) {
                String deny = this.denyList[i2];
                if (!className.startsWith(deny)) continue;
                throw new JSONException("autoType is not support. " + typeName);
            }
        }
        if ((clazz = TypeUtils.getClassFromMapping(typeName)) == null) {
            clazz = this.deserializers.findClass(typeName);
        }
        if (clazz != null) {
            if (expectClass != null && !expectClass.isAssignableFrom(clazz)) {
                throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
            }
            return clazz;
        }
        if (!this.autoTypeSupport) {
            int i3;
            for (i3 = 0; i3 < this.denyList.length; ++i3) {
                String deny = this.denyList[i3];
                if (!className.startsWith(deny)) continue;
                throw new JSONException("autoType is not support. " + typeName);
            }
            for (i3 = 0; i3 < this.acceptList.length; ++i3) {
                String accept = this.acceptList[i3];
                if (!className.startsWith(accept)) continue;
                clazz = TypeUtils.loadClass(typeName, this.defaultClassLoader);
                if (expectClass != null && expectClass.isAssignableFrom(clazz)) {
                    throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
                }
                return clazz;
            }
        }
        if (this.autoTypeSupport || expectClass != null) {
            clazz = TypeUtils.loadClass(typeName, this.defaultClassLoader);
        }
        if (clazz != null) {
            if (ClassLoader.class.isAssignableFrom(clazz) || DataSource.class.isAssignableFrom(clazz)) {
                throw new JSONException("autoType is not support. " + typeName);
            }
            if (expectClass != null) {
                if (expectClass.isAssignableFrom(clazz)) {
                    return clazz;
                }
                throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
            }
        }
        if (!this.autoTypeSupport) {
            throw new JSONException("autoType is not support. " + typeName);
        }
        return clazz;
    }

    static {
        String property = IOUtils.getStringProperty(DENY_PROPERTY);
        DENYS = ParserConfig.splitItemsFormProperty(property);
        property = IOUtils.getStringProperty(AUTOTYPE_SUPPORT_PROPERTY);
        AUTO_SUPPORT = "true".equals(property);
        property = IOUtils.getStringProperty(AUTOTYPE_ACCEPT);
        String[] items = ParserConfig.splitItemsFormProperty(property);
        if (items == null) {
            items = new String[]{};
        }
        AUTO_TYPE_ACCEPT_LIST = items;
        global = new ParserConfig();
        awtError = false;
        jdk8Error = false;
    }
}

