/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.ParseContext;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.ParameterizedTypeImpl;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayListTypeFieldDeserializer
extends FieldDeserializer {
    private final Type itemType;
    private int itemFastMatchToken;
    private ObjectDeserializer deserializer;

    public ArrayListTypeFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        super(clazz, fieldInfo);
        Type fieldType = fieldInfo.fieldType;
        if (fieldType instanceof ParameterizedType) {
            WildcardType wildcardType;
            Type[] upperBounds;
            Type argType = ((ParameterizedType)fieldInfo.fieldType).getActualTypeArguments()[0];
            if (argType instanceof WildcardType && (upperBounds = (wildcardType = (WildcardType)argType).getUpperBounds()).length == 1) {
                argType = upperBounds[0];
            }
            this.itemType = argType;
        } else {
            this.itemType = Object.class;
        }
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }

    @Override
    public void parseField(DefaultJSONParser parser, Object object, Type objectType, Map<String, Object> fieldValues) {
        if (parser.lexer.token() == 8) {
            this.setValue(object, null);
            return;
        }
        ArrayList list = new ArrayList();
        ParseContext context = parser.getContext();
        parser.setContext(context, object, this.fieldInfo.name);
        this.parseArray(parser, objectType, list);
        parser.setContext(context);
        if (object == null) {
            fieldValues.put(this.fieldInfo.name, list);
        } else {
            this.setValue(object, list);
        }
    }

    public final void parseArray(DefaultJSONParser parser, Type objectType, Collection array) {
        JSONLexer lexer;
        Type itemType = this.itemType;
        ObjectDeserializer itemTypeDeser = this.deserializer;
        if (objectType instanceof ParameterizedType) {
            ParameterizedType parameterizedItemType;
            Type[] itemActualTypeArgs;
            if (itemType instanceof TypeVariable) {
                TypeVariable typeVar = (TypeVariable)itemType;
                ParameterizedType paramType = (ParameterizedType)objectType;
                Class objectClass = null;
                if (paramType.getRawType() instanceof Class) {
                    objectClass = (Class)paramType.getRawType();
                }
                int paramIndex = -1;
                if (objectClass != null) {
                    int size = objectClass.getTypeParameters().length;
                    for (int i2 = 0; i2 < size; ++i2) {
                        TypeVariable item = objectClass.getTypeParameters()[i2];
                        if (!item.getName().equals(typeVar.getName())) continue;
                        paramIndex = i2;
                        break;
                    }
                }
                if (paramIndex != -1 && !(itemType = paramType.getActualTypeArguments()[paramIndex]).equals(this.itemType)) {
                    itemTypeDeser = parser.getConfig().getDeserializer(itemType);
                }
            } else if (itemType instanceof ParameterizedType && (itemActualTypeArgs = (parameterizedItemType = (ParameterizedType)itemType).getActualTypeArguments()).length == 1 && itemActualTypeArgs[0] instanceof TypeVariable) {
                TypeVariable typeVar = (TypeVariable)itemActualTypeArgs[0];
                ParameterizedType paramType = (ParameterizedType)objectType;
                Class objectClass = null;
                if (paramType.getRawType() instanceof Class) {
                    objectClass = (Class)paramType.getRawType();
                }
                int paramIndex = -1;
                if (objectClass != null) {
                    int size = objectClass.getTypeParameters().length;
                    for (int i3 = 0; i3 < size; ++i3) {
                        TypeVariable item = objectClass.getTypeParameters()[i3];
                        if (!item.getName().equals(typeVar.getName())) continue;
                        paramIndex = i3;
                        break;
                    }
                }
                if (paramIndex != -1) {
                    itemActualTypeArgs[0] = paramType.getActualTypeArguments()[paramIndex];
                    itemType = new ParameterizedTypeImpl(itemActualTypeArgs, parameterizedItemType.getOwnerType(), parameterizedItemType.getRawType());
                }
            }
        }
        if ((lexer = parser.lexer).token() == 14) {
            if (itemTypeDeser == null) {
                itemTypeDeser = this.deserializer = parser.getConfig().getDeserializer(itemType);
                this.itemFastMatchToken = this.deserializer.getFastMatchToken();
            }
            lexer.nextToken(this.itemFastMatchToken);
            int i4 = 0;
            while (true) {
                if (lexer.isEnabled(Feature.AllowArbitraryCommas)) {
                    while (lexer.token() == 16) {
                        lexer.nextToken();
                    }
                }
                if (lexer.token() == 15) break;
                Object val = itemTypeDeser.deserialze(parser, itemType, i4);
                array.add(val);
                parser.checkListResolve(array);
                if (lexer.token() == 16) {
                    lexer.nextToken(this.itemFastMatchToken);
                }
                ++i4;
            }
            lexer.nextToken(16);
        } else {
            if (itemTypeDeser == null) {
                itemTypeDeser = this.deserializer = parser.getConfig().getDeserializer(itemType);
            }
            Object val = itemTypeDeser.deserialze(parser, itemType, 0);
            array.add(val);
            parser.checkListResolve(array);
        }
    }
}

