/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Type;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumDeserializer
implements ObjectDeserializer {
    private final Class<?> enumClass;
    protected final Enum[] enums;
    protected final Enum[] ordinalEnums;
    protected long[] enumNameHashCodes;

    public EnumDeserializer(Class<?> enumClass) {
        int i2;
        this.enumClass = enumClass;
        this.ordinalEnums = (Enum[])enumClass.getEnumConstants();
        long[] enumNameHashCodes = new long[this.ordinalEnums.length];
        this.enumNameHashCodes = new long[this.ordinalEnums.length];
        for (i2 = 0; i2 < this.ordinalEnums.length; ++i2) {
            String name = this.ordinalEnums[i2].name();
            long hash = -2128831035L;
            for (int j2 = 0; j2 < name.length(); ++j2) {
                char ch = name.charAt(j2);
                hash ^= (long)ch;
                hash *= 16777619L;
            }
            enumNameHashCodes[i2] = hash;
            this.enumNameHashCodes[i2] = hash;
        }
        Arrays.sort(this.enumNameHashCodes);
        this.enums = new Enum[this.ordinalEnums.length];
        block2: for (i2 = 0; i2 < this.enumNameHashCodes.length; ++i2) {
            for (int j3 = 0; j3 < enumNameHashCodes.length; ++j3) {
                if (this.enumNameHashCodes[i2] != enumNameHashCodes[j3]) continue;
                this.enums[i2] = this.ordinalEnums[j3];
                continue block2;
            }
        }
    }

    public Enum getEnumByHashCode(long hashCode) {
        if (this.enums == null) {
            return null;
        }
        int enumIndex = Arrays.binarySearch(this.enumNameHashCodes, hashCode);
        if (enumIndex < 0) {
            return null;
        }
        return this.enums[enumIndex];
    }

    public Enum<?> valueOf(int ordinal) {
        return this.ordinalEnums[ordinal];
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        try {
            JSONLexer lexer = parser.lexer;
            int token = lexer.token();
            if (token == 2) {
                int intValue = lexer.intValue();
                lexer.nextToken(16);
                if (intValue < 0 || intValue > this.ordinalEnums.length) {
                    throw new JSONException("parse enum " + this.enumClass.getName() + " error, value : " + intValue);
                }
                return (T)this.ordinalEnums[intValue];
            }
            if (token == 4) {
                String strVal = lexer.stringVal();
                lexer.nextToken(16);
                if (strVal.length() == 0) {
                    return null;
                }
                return (T)Enum.valueOf(this.enumClass, strVal);
            }
            if (token == 8) {
                Object value = null;
                lexer.nextToken(16);
                return null;
            }
            Object value = parser.parse();
            throw new JSONException("parse enum " + this.enumClass.getName() + " error, value : " + value);
        }
        catch (JSONException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new JSONException(e3.getMessage(), e3);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

