/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;

public final class ListSerializer
implements ObjectSerializer {
    public static final ListSerializer instance = new ListSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features2) throws IOException {
        boolean writeClassName = serializer.out.isEnabled(SerializerFeature.WriteClassName);
        SerializeWriter out = serializer.out;
        Type elementType = null;
        if (writeClassName) {
            elementType = TypeUtils.getCollectionItemType(fieldType);
        }
        if (object == null) {
            out.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        List list = (List)object;
        if (list.size() == 0) {
            out.append("[]");
            return;
        }
        SerialContext context = serializer.context;
        serializer.setContext(context, object, fieldName, 0);
        ObjectSerializer itemSerializer = null;
        try {
            if (out.isEnabled(SerializerFeature.PrettyFormat)) {
                out.append('[');
                serializer.incrementIndent();
                int i2 = 0;
                for (Object item : list) {
                    if (i2 != 0) {
                        out.append(',');
                    }
                    serializer.println();
                    if (item != null) {
                        if (serializer.containsReference(item)) {
                            serializer.writeReference(item);
                        } else {
                            SerialContext itemContext;
                            itemSerializer = serializer.getObjectWriter(item.getClass());
                            serializer.context = itemContext = new SerialContext(context, object, fieldName, 0, 0);
                            itemSerializer.write(serializer, item, i2, elementType, 0);
                        }
                    } else {
                        serializer.out.writeNull();
                    }
                    ++i2;
                }
                serializer.decrementIdent();
                serializer.println();
                out.append(']');
                return;
            }
            out.append('[');
            int size = list.size();
            for (int i3 = 0; i3 < size; ++i3) {
                Object item = list.get(i3);
                if (i3 != 0) {
                    out.append(',');
                }
                if (item == null) {
                    out.append("null");
                    continue;
                }
                Class<?> clazz = item.getClass();
                if (clazz == Integer.class) {
                    out.writeInt((Integer)item);
                    continue;
                }
                if (clazz == Long.class) {
                    long val = (Long)item;
                    if (writeClassName) {
                        out.writeLong(val);
                        out.write(76);
                        continue;
                    }
                    out.writeLong(val);
                    continue;
                }
                if (!out.disableCircularReferenceDetect) {
                    SerialContext itemContext;
                    serializer.context = itemContext = new SerialContext(context, object, fieldName, 0, 0);
                }
                if (serializer.containsReference(item)) {
                    serializer.writeReference(item);
                    continue;
                }
                itemSerializer = serializer.getObjectWriter(item.getClass());
                itemSerializer.write(serializer, item, i3, elementType, 0);
            }
            out.append(']');
        }
        finally {
            serializer.context = context;
        }
    }
}

