/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntiCollisionHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    volatile transient Set<K> keySet = null;
    volatile transient Collection<V> values = null;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry<K, V>[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    static final int M_MASK = -2023358765;
    static final int SEED = -2128831035;
    static final int KEY = 16777619;
    final int random = new Random().nextInt(99999);
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private static final long serialVersionUID = 362498820763181265L;

    private int hashString(String key) {
        int hash = -2128831035 * this.random;
        for (int i2 = 0; i2 < key.length(); ++i2) {
            hash = hash * 16777619 ^ key.charAt(i2);
        }
        return (hash ^ hash >> 1) & 0x8765FED3;
    }

    public AntiCollisionHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.init();
    }

    public AntiCollisionHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public AntiCollisionHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
        this.init();
    }

    public AntiCollisionHashMap(Map<? extends K, ? extends V> m2) {
        this(Math.max((int)((float)m2.size() / 0.75f) + 1, 16), 0.75f);
        super.putAllForCreate(m2);
    }

    void init() {
    }

    static int hash(int h2) {
        h2 *= h2;
        h2 ^= h2 >>> 20 ^ h2 >>> 12;
        return h2 ^ h2 >>> 7 ^ h2 >>> 4;
    }

    static int indexFor(int h2, int length) {
        return h2 & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return this.getForNullKey();
        }
        int hash = 0;
        hash = key instanceof String ? AntiCollisionHashMap.hash(this.hashString((String)key)) : AntiCollisionHashMap.hash(key.hashCode());
        Entry<K, V> e2 = this.table[AntiCollisionHashMap.indexFor(hash, this.table.length)];
        while (e2 != null) {
            Object k2;
            if (e2.hash == hash && ((k2 = e2.key) == key || key.equals(k2))) {
                return e2.value;
            }
            e2 = e2.next;
        }
        return null;
    }

    private V getForNullKey() {
        Entry<K, V> e2 = this.table[0];
        while (e2 != null) {
            if (e2.key == null) {
                return e2.value;
            }
            e2 = e2.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    final Entry<K, V> getEntry(Object key) {
        int hash = key == null ? 0 : (key instanceof String ? AntiCollisionHashMap.hash(this.hashString((String)key)) : AntiCollisionHashMap.hash(key.hashCode()));
        Entry<K, V> e2 = this.table[AntiCollisionHashMap.indexFor(hash, this.table.length)];
        while (e2 != null) {
            Object k2;
            if (e2.hash == hash && ((k2 = e2.key) == key || key != null && key.equals(k2))) {
                return e2;
            }
            e2 = e2.next;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            return this.putForNullKey(value);
        }
        int hash = 0;
        hash = key instanceof String ? AntiCollisionHashMap.hash(this.hashString((String)key)) : AntiCollisionHashMap.hash(key.hashCode());
        int i2 = AntiCollisionHashMap.indexFor(hash, this.table.length);
        Entry<K, V> e2 = this.table[i2];
        while (e2 != null) {
            Object k2;
            if (e2.hash == hash && ((k2 = e2.key) == key || key.equals(k2))) {
                Object oldValue = e2.value;
                e2.value = value;
                e2.recordAccess(this);
                return oldValue;
            }
            e2 = e2.next;
        }
        ++this.modCount;
        this.addEntry(hash, key, value, i2);
        return null;
    }

    private V putForNullKey(V value) {
        Entry<K, V> e2 = this.table[0];
        while (e2 != null) {
            if (e2.key == null) {
                Object oldValue = e2.value;
                e2.value = value;
                e2.recordAccess(this);
                return oldValue;
            }
            e2 = e2.next;
        }
        ++this.modCount;
        this.addEntry(0, null, value, 0);
        return null;
    }

    private void putForCreate(K key, V value) {
        int hash = key == null ? 0 : (key instanceof String ? AntiCollisionHashMap.hash(this.hashString((String)key)) : AntiCollisionHashMap.hash(key.hashCode()));
        int i2 = AntiCollisionHashMap.indexFor(hash, this.table.length);
        Entry<K, V> e2 = this.table[i2];
        while (e2 != null) {
            Object k2;
            if (e2.hash == hash && ((k2 = e2.key) == key || key != null && key.equals(k2))) {
                e2.value = value;
                return;
            }
            e2 = e2.next;
        }
        this.createEntry(hash, key, value, i2);
    }

    private void putAllForCreate(Map<? extends K, ? extends V> m2) {
        for (Map.Entry<K, V> e2 : m2.entrySet()) {
            this.putForCreate(e2.getKey(), e2.getValue());
        }
    }

    void resize(int newCapacity) {
        Entry<K, V>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry[] newTable) {
        Entry<K, V>[] src = this.table;
        int newCapacity = newTable.length;
        for (int j2 = 0; j2 < src.length; ++j2) {
            Entry next;
            Entry<K, V> e2 = src[j2];
            if (e2 == null) continue;
            src[j2] = null;
            do {
                next = e2.next;
                int i2 = AntiCollisionHashMap.indexFor(e2.hash, newCapacity);
                e2.next = newTable[i2];
                newTable[i2] = e2;
            } while ((e2 = next) != null);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m2) {
        int numKeysToBeAdded = m2.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (Map.Entry<K, V> e2 : m2.entrySet()) {
            this.put(e2.getKey(), e2.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> e2 = this.removeEntryForKey(key);
        return e2 == null ? null : (V)e2.value;
    }

    final Entry<K, V> removeEntryForKey(Object key) {
        Entry<K, V> prev;
        int hash = key == null ? 0 : (key instanceof String ? AntiCollisionHashMap.hash(this.hashString((String)key)) : AntiCollisionHashMap.hash(key.hashCode()));
        int i2 = AntiCollisionHashMap.indexFor(hash, this.table.length);
        Entry<K, V> e2 = prev = this.table[i2];
        while (e2 != null) {
            Object k2;
            Entry next = e2.next;
            if (e2.hash == hash && ((k2 = e2.key) == key || key != null && key.equals(k2))) {
                ++this.modCount;
                --this.size;
                if (prev == e2) {
                    this.table[i2] = next;
                } else {
                    prev.next = next;
                }
                e2.recordRemoval(this);
                return e2;
            }
            prev = e2;
            e2 = next;
        }
        return e2;
    }

    final Entry<K, V> removeMapping(Object o2) {
        Entry<K, V> prev;
        if (!(o2 instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)o2;
        Object key = entry.getKey();
        int hash = key == null ? 0 : (key instanceof String ? AntiCollisionHashMap.hash(this.hashString((String)key)) : AntiCollisionHashMap.hash(key.hashCode()));
        int i2 = AntiCollisionHashMap.indexFor(hash, this.table.length);
        Entry<K, V> e2 = prev = this.table[i2];
        while (e2 != null) {
            Entry next = e2.next;
            if (e2.hash == hash && e2.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e2) {
                    this.table[i2] = next;
                } else {
                    prev.next = next;
                }
                e2.recordRemoval(this);
                return e2;
            }
            prev = e2;
            e2 = next;
        }
        return e2;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Entry<K, V>[] tab = this.table;
        for (int i2 = 0; i2 < tab.length; ++i2) {
            tab[i2] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        Entry<K, V>[] tab = this.table;
        for (int i2 = 0; i2 < tab.length; ++i2) {
            Entry<K, V> e2 = tab[i2];
            while (e2 != null) {
                if (value.equals(e2.value)) {
                    return true;
                }
                e2 = e2.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry<K, V>[] tab = this.table;
        for (int i2 = 0; i2 < tab.length; ++i2) {
            Entry<K, V> e2 = tab[i2];
            while (e2 != null) {
                if (e2.value == null) {
                    return true;
                }
                e2 = e2.next;
            }
        }
        return false;
    }

    @Override
    public Object clone() {
        AntiCollisionHashMap result = null;
        try {
            result = (AntiCollisionHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        result.table = new Entry[this.table.length];
        result.entrySet = null;
        result.modCount = 0;
        result.size = 0;
        result.init();
        result.putAllForCreate(this);
        return result;
    }

    void addEntry(int hash, K key, V value, int bucketIndex) {
        Entry<K, V> e2 = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<K, V>(hash, key, value, e2);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, K key, V value, int bucketIndex) {
        Entry<K, V> e2 = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<K, V>(hash, key, value, e2);
        ++this.size;
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet0();
    }

    private Set<Map.Entry<K, V>> entrySet0() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        Iterator<Map.Entry<K, V>> i2 = this.size > 0 ? this.entrySet0().iterator() : null;
        s2.defaultWriteObject();
        s2.writeInt(this.table.length);
        s2.writeInt(this.size);
        if (i2 != null) {
            while (i2.hasNext()) {
                Map.Entry<K, V> e2 = i2.next();
                s2.writeObject(e2.getKey());
                s2.writeObject(e2.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        int numBuckets = s2.readInt();
        this.table = new Entry[numBuckets];
        this.init();
        int size = s2.readInt();
        for (int i2 = 0; i2 < size; ++i2) {
            Object key = s2.readObject();
            Object value = s2.readObject();
            this.putForCreate(key, value);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return AntiCollisionHashMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            Entry candidate = AntiCollisionHashMap.this.getEntry(e2.getKey());
            return candidate != null && candidate.equals(e2);
        }

        @Override
        public boolean remove(Object o2) {
            return AntiCollisionHashMap.this.removeMapping(o2) != null;
        }

        @Override
        public int size() {
            return AntiCollisionHashMap.this.size;
        }

        @Override
        public void clear() {
            AntiCollisionHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return AntiCollisionHashMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return AntiCollisionHashMap.this.size;
        }

        @Override
        public boolean contains(Object o2) {
            return AntiCollisionHashMap.this.containsValue(o2);
        }

        @Override
        public void clear() {
            AntiCollisionHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return AntiCollisionHashMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return AntiCollisionHashMap.this.size;
        }

        @Override
        public boolean contains(Object o2) {
            return AntiCollisionHashMap.this.containsKey(o2);
        }

        @Override
        public boolean remove(Object o2) {
            return AntiCollisionHashMap.this.removeEntryForKey(o2) != null;
        }

        @Override
        public void clear() {
            AntiCollisionHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry<K, V> next;
        int expectedModCount;
        int index;
        Entry<K, V> current;

        HashIterator() {
            this.expectedModCount = AntiCollisionHashMap.this.modCount;
            if (AntiCollisionHashMap.this.size > 0) {
                Entry<K, V>[] t2 = AntiCollisionHashMap.this.table;
                while (this.index < t2.length && (this.next = t2[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<K, V> nextEntry() {
            if (AntiCollisionHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e2 = this.next;
            if (e2 == null) {
                throw new NoSuchElementException();
            }
            this.next = e2.next;
            if (this.next == null) {
                Entry<K, V>[] t2 = AntiCollisionHashMap.this.table;
                while (this.index < t2.length && (this.next = t2[this.index++]) == null) {
                }
            }
            this.current = e2;
            return e2;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (AntiCollisionHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object k2 = this.current.key;
            this.current = null;
            AntiCollisionHashMap.this.removeEntryForKey(k2);
            this.expectedModCount = AntiCollisionHashMap.this.modCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;
        Entry<K, V> next;
        final int hash;

        Entry(int h2, K k2, V v2, Entry<K, V> n2) {
            this.value = v2;
            this.next = n2;
            this.key = k2;
            this.hash = h2;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o2) {
            Object v2;
            V v1;
            Object k2;
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            K k1 = this.getKey();
            return (k1 == (k2 = e2.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e2.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(AntiCollisionHashMap<K, V> m2) {
        }

        void recordRemoval(AntiCollisionHashMap<K, V> m2) {
        }
    }
}

