/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.MalformedInputException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Properties;

public class IOUtils {
    public static final String FASTJSON_PROPERTIES = "fastjson.properties";
    public static final String FASTJSON_COMPATIBLEWITHJAVABEAN = "fastjson.compatibleWithJavaBean";
    public static final String FASTJSON_COMPATIBLEWITHFIELDNAME = "fastjson.compatibleWithFieldName";
    public static final Properties DEFAULT_PROPERTIES;
    public static final Charset UTF8;
    public static final char[] DIGITS;
    public static final boolean[] firstIdentifierFlags;
    public static final boolean[] identifierFlags;
    public static final byte[] specicalFlags_doubleQuotes;
    public static final byte[] specicalFlags_singleQuotes;
    public static final boolean[] specicalFlags_doubleQuotesFlags;
    public static final boolean[] specicalFlags_singleQuotesFlags;
    public static final char[] replaceChars;
    public static final char[] ASCII_CHARS;
    static final char[] digits;
    static final char[] DigitTens;
    static final char[] DigitOnes;
    static final int[] sizeTable;
    public static final char[] CA;
    public static final int[] IA;

    public static String getStringProperty(String name) {
        String prop = null;
        try {
            prop = System.getProperty(name);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return prop == null ? DEFAULT_PROPERTIES.getProperty(name) : prop;
    }

    public static void loadPropertiesFromFile() {
        InputStream imputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl != null) {
                    return cl.getResourceAsStream(IOUtils.FASTJSON_PROPERTIES);
                }
                return ClassLoader.getSystemResourceAsStream(IOUtils.FASTJSON_PROPERTIES);
            }
        });
        if (null != imputStream) {
            try {
                DEFAULT_PROPERTIES.load(imputStream);
                imputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable x2) {
        if (x2 != null) {
            try {
                x2.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int stringSize(long x2) {
        long p2 = 10L;
        for (int i2 = 1; i2 < 19; ++i2) {
            if (x2 < p2) {
                return i2;
            }
            p2 = 10L * p2;
        }
        return 19;
    }

    public static void getChars(long i2, int index, char[] buf) {
        int q2;
        int r2;
        int charPos = index;
        int sign = 0;
        if (i2 < 0L) {
            sign = 45;
            i2 = -i2;
        }
        while (i2 > Integer.MAX_VALUE) {
            long q3 = i2 / 100L;
            r2 = (int)(i2 - ((q3 << 6) + (q3 << 5) + (q3 << 2)));
            i2 = q3;
            buf[--charPos] = DigitOnes[r2];
            buf[--charPos] = DigitTens[r2];
        }
        int i22 = (int)i2;
        while (i22 >= 65536) {
            q2 = i22 / 100;
            r2 = i22 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i22 = q2;
            buf[--charPos] = DigitOnes[r2];
            buf[--charPos] = DigitTens[r2];
        }
        do {
            q2 = i22 * 52429 >>> 19;
            r2 = i22 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = digits[r2];
        } while ((i22 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    public static void getChars(int i2, int index, char[] buf) {
        int r2;
        int q2;
        int charPos = index;
        int sign = 0;
        if (i2 < 0) {
            sign = 45;
            i2 = -i2;
        }
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r2 = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = DigitOnes[r2];
            buf[--charPos] = DigitTens[r2];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r2 = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = digits[r2];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    public static void getChars(byte b2, int index, char[] buf) {
        int q2;
        int i2 = b2;
        int charPos = index;
        int sign = 0;
        if (i2 < 0) {
            sign = 45;
            i2 = -i2;
        }
        do {
            q2 = i2 * 52429 >>> 19;
            int r2 = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = digits[r2];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    public static int stringSize(int x2) {
        int i2 = 0;
        while (x2 > sizeTable[i2]) {
            ++i2;
        }
        return i2 + 1;
    }

    public static void decode(CharsetDecoder charsetDecoder, ByteBuffer byteBuf, CharBuffer charByte) {
        try {
            CoderResult cr = charsetDecoder.decode(byteBuf, charByte, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = charsetDecoder.flush(charByte)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x2) {
            throw new JSONException("utf8 decode error, " + x2.getMessage(), x2);
        }
    }

    public static boolean firstIdentifier(char ch) {
        return ch < firstIdentifierFlags.length && firstIdentifierFlags[ch];
    }

    public static boolean isIdent(char ch) {
        return ch < identifierFlags.length && identifierFlags[ch];
    }

    public static byte[] decodeBase64(char[] chars, int offset, int charsLen) {
        int sIx;
        if (charsLen == 0) {
            return new byte[0];
        }
        int eIx = offset + charsLen - 1;
        for (sIx = offset; sIx < eIx && IA[chars[sIx]] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[chars[eIx]] < 0) {
            --eIx;
        }
        int pad = chars[eIx] == '=' ? (chars[eIx - 1] == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = charsLen > 76 ? (chars[76] == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] bytes = new byte[len];
        int d2 = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d2 < eLen) {
            int i2 = IA[chars[sIx++]] << 18 | IA[chars[sIx++]] << 12 | IA[chars[sIx++]] << 6 | IA[chars[sIx++]];
            bytes[d2++] = (byte)(i2 >> 16);
            bytes[d2++] = (byte)(i2 >> 8);
            bytes[d2++] = (byte)i2;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d2 < len) {
            int i3 = 0;
            int j2 = 0;
            while (sIx <= eIx - pad) {
                i3 |= IA[chars[sIx++]] << 18 - j2 * 6;
                ++j2;
            }
            int r2 = 16;
            while (d2 < len) {
                bytes[d2++] = (byte)(i3 >> r2);
                r2 -= 8;
            }
        }
        return bytes;
    }

    public static byte[] decodeBase64(String chars, int offset, int charsLen) {
        int sIx;
        if (charsLen == 0) {
            return new byte[0];
        }
        int eIx = offset + charsLen - 1;
        for (sIx = offset; sIx < eIx && IA[chars.charAt(sIx)] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[chars.charAt(eIx)] < 0) {
            --eIx;
        }
        int pad = chars.charAt(eIx) == '=' ? (chars.charAt(eIx - 1) == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = charsLen > 76 ? (chars.charAt(76) == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] bytes = new byte[len];
        int d2 = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d2 < eLen) {
            int i2 = IA[chars.charAt(sIx++)] << 18 | IA[chars.charAt(sIx++)] << 12 | IA[chars.charAt(sIx++)] << 6 | IA[chars.charAt(sIx++)];
            bytes[d2++] = (byte)(i2 >> 16);
            bytes[d2++] = (byte)(i2 >> 8);
            bytes[d2++] = (byte)i2;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d2 < len) {
            int i3 = 0;
            int j2 = 0;
            while (sIx <= eIx - pad) {
                i3 |= IA[chars.charAt(sIx++)] << 18 - j2 * 6;
                ++j2;
            }
            int r2 = 16;
            while (d2 < len) {
                bytes[d2++] = (byte)(i3 >> r2);
                r2 -= 8;
            }
        }
        return bytes;
    }

    public static byte[] decodeBase64(String s2) {
        int sIx;
        int sLen = s2.length();
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && IA[s2.charAt(sIx) & 0xFF] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[s2.charAt(eIx) & 0xFF] < 0) {
            --eIx;
        }
        int pad = s2.charAt(eIx) == '=' ? (s2.charAt(eIx - 1) == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (s2.charAt(76) == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d2 = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d2 < eLen) {
            int i2 = IA[s2.charAt(sIx++)] << 18 | IA[s2.charAt(sIx++)] << 12 | IA[s2.charAt(sIx++)] << 6 | IA[s2.charAt(sIx++)];
            dArr[d2++] = (byte)(i2 >> 16);
            dArr[d2++] = (byte)(i2 >> 8);
            dArr[d2++] = (byte)i2;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d2 < len) {
            int i3 = 0;
            int j2 = 0;
            while (sIx <= eIx - pad) {
                i3 |= IA[s2.charAt(sIx++)] << 18 - j2 * 6;
                ++j2;
            }
            int r2 = 16;
            while (d2 < len) {
                dArr[d2++] = (byte)(i3 >> r2);
                r2 -= 8;
            }
        }
        return dArr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int encodeUTF8(char[] sa, int sp2, int len, byte[] da) {
        int sl = sp2 + len;
        int dp = 0;
        int dlASCII = dp + Math.min(len, da.length);
        while (dp < dlASCII && sa[sp2] < '\u0080') {
            da[dp++] = (byte)sa[sp2++];
        }
        while (sp2 < sl) {
            int c2;
            if ((c2 = sa[sp2++]) < 128) {
                da[dp++] = (byte)c2;
                continue;
            }
            if (c2 < 2048) {
                da[dp++] = (byte)(0xC0 | c2 >> 6);
                da[dp++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            if (c2 >= 55296 && c2 < 57344) {
                int uc;
                int ip = sp2 - 1;
                if (Character.isHighSurrogate((char)c2)) {
                    if (sl - ip < 2) {
                        uc = -1;
                    } else {
                        char d2 = sa[ip + 1];
                        if (!Character.isLowSurrogate(d2)) throw new JSONException("encodeUTF8 error", new MalformedInputException(1));
                        uc = Character.toCodePoint((char)c2, d2);
                    }
                } else {
                    if (Character.isLowSurrogate((char)c2)) {
                        throw new JSONException("encodeUTF8 error", new MalformedInputException(1));
                    }
                    uc = c2;
                }
                if (uc < 0) {
                    da[dp++] = 63;
                    continue;
                }
                da[dp++] = (byte)(0xF0 | uc >> 18);
                da[dp++] = (byte)(0x80 | uc >> 12 & 0x3F);
                da[dp++] = (byte)(0x80 | uc >> 6 & 0x3F);
                da[dp++] = (byte)(0x80 | uc & 0x3F);
                ++sp2;
                continue;
            }
            da[dp++] = (byte)(0xE0 | c2 >> 12);
            da[dp++] = (byte)(0x80 | c2 >> 6 & 0x3F);
            da[dp++] = (byte)(0x80 | c2 & 0x3F);
        }
        return dp;
    }

    public static int decodeUTF8(byte[] sa, int sp2, int len, char[] da) {
        int sl = sp2 + len;
        int dp = 0;
        int dlASCII = Math.min(len, da.length);
        while (dp < dlASCII && sa[sp2] >= 0) {
            da[dp++] = (char)sa[sp2++];
        }
        while (sp2 < sl) {
            byte b3;
            byte b2;
            byte b1;
            if ((b1 = sa[sp2++]) >= 0) {
                da[dp++] = (char)b1;
                continue;
            }
            if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                if (sp2 < sl) {
                    if (((b2 = sa[sp2++]) & 0xC0) != 128) {
                        return -1;
                    }
                    da[dp++] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                    continue;
                }
                return -1;
            }
            if (b1 >> 4 == -2) {
                if (sp2 + 1 < sl) {
                    boolean isSurrogate;
                    b2 = sa[sp2++];
                    b3 = sa[sp2++];
                    if (b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                        return -1;
                    }
                    char c2 = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                    boolean bl = isSurrogate = c2 >= '\ud800' && c2 < '\ue000';
                    if (isSurrogate) {
                        return -1;
                    }
                    da[dp++] = c2;
                    continue;
                }
                return -1;
            }
            if (b1 >> 3 == -2) {
                if (sp2 + 2 < sl) {
                    b2 = sa[sp2++];
                    b3 = sa[sp2++];
                    byte b4 = sa[sp2++];
                    int uc = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128 || !Character.isSupplementaryCodePoint(uc)) {
                        return -1;
                    }
                    da[dp++] = (char)((uc >>> 10) + 55232);
                    da[dp++] = (char)((uc & 0x3FF) + 56320);
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return dp;
    }

    public static String readAll(Reader reader) {
        StringBuilder buf = new StringBuilder();
        try {
            int len;
            char[] chars = new char[2048];
            while ((len = reader.read(chars, 0, chars.length)) >= 0) {
                buf.append(chars, 0, len);
            }
        }
        catch (Exception ex) {
            throw new JSONException("read string from reader error", ex);
        }
        return buf.toString();
    }

    static {
        int i2;
        int c2;
        DEFAULT_PROPERTIES = new Properties();
        UTF8 = Charset.forName("UTF-8");
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        firstIdentifierFlags = new boolean[256];
        for (c2 = 0; c2 < firstIdentifierFlags.length; c2 = (int)((char)(c2 + 1))) {
            if (c2 >= 65 && c2 <= 90) {
                IOUtils.firstIdentifierFlags[c2] = true;
                continue;
            }
            if (c2 >= 97 && c2 <= 122) {
                IOUtils.firstIdentifierFlags[c2] = true;
                continue;
            }
            if (c2 != 95) continue;
            IOUtils.firstIdentifierFlags[c2] = true;
        }
        identifierFlags = new boolean[256];
        for (c2 = 0; c2 < identifierFlags.length; c2 = (int)((char)(c2 + 1))) {
            if (c2 >= 65 && c2 <= 90) {
                IOUtils.identifierFlags[c2] = true;
                continue;
            }
            if (c2 >= 97 && c2 <= 122) {
                IOUtils.identifierFlags[c2] = true;
                continue;
            }
            if (c2 == 95) {
                IOUtils.identifierFlags[c2] = true;
                continue;
            }
            if (c2 < 48 || c2 > 57) continue;
            IOUtils.identifierFlags[c2] = true;
        }
        try {
            new PropertiesInitializer().autoConfig();
        }
        catch (Throwable c3) {
            // empty catch block
        }
        specicalFlags_doubleQuotes = new byte[161];
        specicalFlags_singleQuotes = new byte[161];
        specicalFlags_doubleQuotesFlags = new boolean[161];
        specicalFlags_singleQuotesFlags = new boolean[161];
        replaceChars = new char[93];
        IOUtils.specicalFlags_doubleQuotes[0] = 4;
        IOUtils.specicalFlags_doubleQuotes[1] = 4;
        IOUtils.specicalFlags_doubleQuotes[2] = 4;
        IOUtils.specicalFlags_doubleQuotes[3] = 4;
        IOUtils.specicalFlags_doubleQuotes[4] = 4;
        IOUtils.specicalFlags_doubleQuotes[5] = 4;
        IOUtils.specicalFlags_doubleQuotes[6] = 4;
        IOUtils.specicalFlags_doubleQuotes[7] = 4;
        IOUtils.specicalFlags_doubleQuotes[8] = 1;
        IOUtils.specicalFlags_doubleQuotes[9] = 1;
        IOUtils.specicalFlags_doubleQuotes[10] = 1;
        IOUtils.specicalFlags_doubleQuotes[11] = 4;
        IOUtils.specicalFlags_doubleQuotes[12] = 1;
        IOUtils.specicalFlags_doubleQuotes[13] = 1;
        IOUtils.specicalFlags_doubleQuotes[34] = 1;
        IOUtils.specicalFlags_doubleQuotes[92] = 1;
        IOUtils.specicalFlags_singleQuotes[0] = 4;
        IOUtils.specicalFlags_singleQuotes[1] = 4;
        IOUtils.specicalFlags_singleQuotes[2] = 4;
        IOUtils.specicalFlags_singleQuotes[3] = 4;
        IOUtils.specicalFlags_singleQuotes[4] = 4;
        IOUtils.specicalFlags_singleQuotes[5] = 4;
        IOUtils.specicalFlags_singleQuotes[6] = 4;
        IOUtils.specicalFlags_singleQuotes[7] = 4;
        IOUtils.specicalFlags_singleQuotes[8] = 1;
        IOUtils.specicalFlags_singleQuotes[9] = 1;
        IOUtils.specicalFlags_singleQuotes[10] = 1;
        IOUtils.specicalFlags_singleQuotes[11] = 4;
        IOUtils.specicalFlags_singleQuotes[12] = 1;
        IOUtils.specicalFlags_singleQuotes[13] = 1;
        IOUtils.specicalFlags_singleQuotes[92] = 1;
        IOUtils.specicalFlags_singleQuotes[39] = 1;
        for (i2 = 14; i2 <= 31; ++i2) {
            IOUtils.specicalFlags_doubleQuotes[i2] = 4;
            IOUtils.specicalFlags_singleQuotes[i2] = 4;
        }
        for (i2 = 127; i2 < 160; ++i2) {
            IOUtils.specicalFlags_doubleQuotes[i2] = 4;
            IOUtils.specicalFlags_singleQuotes[i2] = 4;
        }
        for (i2 = 0; i2 < 161; ++i2) {
            IOUtils.specicalFlags_doubleQuotesFlags[i2] = specicalFlags_doubleQuotes[i2] != 0;
            IOUtils.specicalFlags_singleQuotesFlags[i2] = specicalFlags_singleQuotes[i2] != 0;
        }
        IOUtils.replaceChars[0] = 48;
        IOUtils.replaceChars[1] = 49;
        IOUtils.replaceChars[2] = 50;
        IOUtils.replaceChars[3] = 51;
        IOUtils.replaceChars[4] = 52;
        IOUtils.replaceChars[5] = 53;
        IOUtils.replaceChars[6] = 54;
        IOUtils.replaceChars[7] = 55;
        IOUtils.replaceChars[8] = 98;
        IOUtils.replaceChars[9] = 116;
        IOUtils.replaceChars[10] = 110;
        IOUtils.replaceChars[11] = 118;
        IOUtils.replaceChars[12] = 102;
        IOUtils.replaceChars[13] = 114;
        IOUtils.replaceChars[34] = 34;
        IOUtils.replaceChars[39] = 39;
        IOUtils.replaceChars[47] = 47;
        IOUtils.replaceChars[92] = 92;
        ASCII_CHARS = new char[]{'0', '0', '0', '1', '0', '2', '0', '3', '0', '4', '0', '5', '0', '6', '0', '7', '0', '8', '0', '9', '0', 'A', '0', 'B', '0', 'C', '0', 'D', '0', 'E', '0', 'F', '1', '0', '1', '1', '1', '2', '1', '3', '1', '4', '1', '5', '1', '6', '1', '7', '1', '8', '1', '9', '1', 'A', '1', 'B', '1', 'C', '1', 'D', '1', 'E', '1', 'F', '2', '0', '2', '1', '2', '2', '2', '3', '2', '4', '2', '5', '2', '6', '2', '7', '2', '8', '2', '9', '2', 'A', '2', 'B', '2', 'C', '2', 'D', '2', 'E', '2', 'F'};
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
        CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        IA = new int[256];
        Arrays.fill(IA, -1);
        int iS = CA.length;
        for (i2 = 0; i2 < iS; ++i2) {
            IOUtils.IA[IOUtils.CA[i2]] = i2;
        }
        IOUtils.IA[61] = 0;
    }

    static class PropertiesInitializer {
        PropertiesInitializer() {
        }

        public void autoConfig() {
            IOUtils.loadPropertiesFromFile();
            TypeUtils.compatibleWithJavaBean = "true".equals(IOUtils.getStringProperty(IOUtils.FASTJSON_COMPATIBLEWITHJAVABEAN));
            TypeUtils.compatibleWithFieldName = "true".equals(IOUtils.getStringProperty(IOUtils.FASTJSON_COMPATIBLEWITHFIELDNAME));
        }
    }
}

