/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset;

import com.datastax.data.dataset.DataRow;
import com.datastax.data.dataset.DataSetUtils;
import com.datastax.data.dataset.DataTable;
import com.datastax.data.dataset.DataValue;
import com.datastax.data.dataset.NameGenerator;
import com.datastax.data.dataset.Parser;
import com.datastax.data.dataset.event.DataTableEventAdapter;
import com.datastax.data.dataset.event.RowChangeEvent;
import com.datastax.data.dataset.event.TableChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.Visitable;
import net.sf.jga.parser.ParseException;
import net.sf.jga.parser.UnaryFunctorRef;
import net.sf.jga.parser.UncheckedParseException;

public class DataColumn {
    private static final Logger LOG = Logger.getLogger(DataColumn.class.getName());
    protected static final String DEFAULT_NAME_PREFIX = "DataColumn";
    private static final NameGenerator NAMEGEN = new NameGenerator("DataColumn");
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private DataTable table;
    private String name = NAMEGEN.generateName(this);
    private Class type = Object.class;
    private boolean readOnly = false;
    private boolean required = false;
    private Object defaultValue;
    private boolean keyColumn;
    private String expression;
    private UnaryFunctor<DataRow, ?> expImpl;
    private boolean isParsing = false;
    private Set sources = new HashSet();
    DataTableEventAdapter listener = new DataTableEventAdapter(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            super.propertyChange(evt);
            DataColumn.this.getTable().fireDataTableChanged(TableChangeEvent.newColumnChangedEvent(DataColumn.this.getTable(), DataColumn.this));
        }

        @Override
        public void cellChanged(RowChangeEvent evt) {
            DataRow row = (DataRow)evt.getSource();
            DataColumn col = evt.getColumnAffected();
            if (DataColumn.this.sources.contains(col)) {
                row.fireDataRowChanged(RowChangeEvent.newCellChangedEvent(row, DataColumn.this, null, evt.getPriorRowStatus()));
            }
        }
    };

    protected DataColumn(DataTable table) {
        assert (table != null);
        this.table = table;
    }

    public DataTable getTable() {
        return this.table;
    }

    void removeFromTable() {
        this.table = null;
        if (this.expImpl != null) {
            Parser.unregister(this.expImpl, this.listener, this.sources);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name != name) {
            assert (DataSetUtils.isValidName(name));
            assert (!this.table.columns.containsKey(name) && !this.table.selectors.containsKey(name));
            String oldName = this.name;
            this.name = name;
            this.pcs.firePropertyChange("name", oldName, name);
        }
    }

    public Class getType() {
        if (this.expression != null && this.expression.length() > 0 && this.expImpl == null) {
            this.expImpl = this.parseExpression();
        }
        return this.type;
    }

    public void setType(Class type) {
        if (this.type != type) {
            Class oldType = this.type;
            this.type = type == null ? Object.class : type;
            this.pcs.firePropertyChange("type", oldType, type);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        if (this.readOnly != readOnly) {
            boolean oldValue = this.readOnly;
            this.readOnly = readOnly;
            this.pcs.firePropertyChange("readOnly", oldValue, readOnly);
        }
    }

    public boolean isRequired() {
        return this.required || this.keyColumn;
    }

    public void setRequired(boolean required) {
        if (this.required != required) {
            boolean oldValue = this.required;
            this.required = required;
            this.pcs.firePropertyChange("required", oldValue, required);
        }
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        if (this.defaultValue != defaultValue) {
            Object oldVal = this.defaultValue;
            this.defaultValue = defaultValue;
            this.pcs.firePropertyChange("defaultValue", oldVal, defaultValue);
        }
    }

    public boolean isKeyColumn() {
        return this.keyColumn;
    }

    public void setKeyColumn(boolean value) {
        if (value != this.keyColumn) {
            boolean oldVal = this.keyColumn;
            this.keyColumn = value;
            this.pcs.firePropertyChange("keyColumn", oldVal, value);
            if (!oldVal && value && !this.required) {
                this.pcs.firePropertyChange("required", this.required, true);
            } else if (oldVal && !value && !this.required) {
                this.pcs.firePropertyChange("required", true, this.required);
            }
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        if (expression == null) {
            expression = "";
        }
        if (!expression.equals(this.expression)) {
            String oldExpression = this.expression;
            this.expression = expression;
            this.pcs.firePropertyChange("expression", oldExpression, expression);
            if (this.expImpl != null) {
                Parser.unregister(this.expImpl, this.listener, this.sources);
                this.expImpl = null;
            }
        }
    }

    public Object getValueForRow(DataRow row) {
        if (this.expImpl == null) {
            this.expImpl = this.expression == null || this.expression.equals("") ? null : this.parseExpression();
        }
        return this.expImpl == null ? null : this.expImpl.fn((Object)row);
    }

    public String toString() {
        if (this.table == null) {
            return "Column " + this.getName() + " [dropped]";
        }
        return "Column " + this.getTable().getName() + "." + this.getName();
    }

    private Parser getParser() {
        return this.getTable().getDataSet().getParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized UnaryFunctor<DataRow, ?> parseExpression() {
        LOG.log(Level.FINE, "Attempting to create the expression implementation");
        if (this.isParsing) {
            throw new UncheckedParseException("Circular Reference Exception");
        }
        try {
            this.isParsing = true;
            Parser parser = this.getParser();
            UnaryFunctorRef ref = parser.parseComputedColumn(this.getTable(), this, this.expression);
            UnaryFunctor uf = ref.getFunctor();
            this.sources = Parser.register((Visitable)uf, this, this.listener);
            this.setType(ref.getReturnType());
            UnaryFunctor unaryFunctor = uf;
            return unaryFunctor;
        }
        catch (ParseException pe) {
            if (pe.getCause() instanceof UncheckedParseException) {
                throw (UncheckedParseException)pe.getCause();
            }
            LOG.log(Level.FINE, "The expression [{0}] is not valid. {1}", new Object[]{this.expression, pe});
            this.type = Void.TYPE;
            UnaryFunctor<DataRow, ?> unaryFunctor = null;
            return unaryFunctor;
        }
        finally {
            this.isParsing = false;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    boolean dependsOn(Object element) {
        if (element == this) {
            return true;
        }
        for (Object obj : this.sources) {
            if (obj == element) {
                return true;
            }
            if (obj instanceof DataColumn && ((DataColumn)obj).dependsOn(element)) {
                return true;
            }
            if (!(obj instanceof DataValue) || !((DataValue)obj).dependsOn(element)) continue;
            return true;
        }
        return false;
    }
}

