/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;

public abstract class DataCommand {
    private String shortDescription;
    private static final Object UNDEFINED = new Object();
    private Map<String, Object> params = new HashMap<String, Object>();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription == null ? "" : shortDescription;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setParameter(String name, Object value) {
        this.params.put(name, value);
    }

    public void clearParameter(String name) {
        this.params.put(name, UNDEFINED);
    }

    public void clearParameters() {
        for (String name : this.params.keySet()) {
            this.params.put(name, UNDEFINED);
        }
    }

    public Object getParameter(String name) {
        return this.params.get(name);
    }

    public abstract String[] getParameterNames();

    public Object[] getParameterValues() {
        return this.params.values().toArray();
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }
}

