/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DataConnection {
    private static final Logger LOG = Logger.getLogger(DataConnection.class.getName());
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean connected = false;

    public void setConnected(boolean b2) {
        if (b2 && !this.connected) {
            try {
                LOG.fine("Attempting to connect to the data store");
                this.connect();
                this.connected = true;
                LOG.fine("Connected to the data store, firing property change event");
                this.pcs.firePropertyChange("connected", false, true);
            }
            catch (Exception e2) {
                LOG.log(Level.SEVERE, "Failed to connect to the data store.", e2);
                this.connected = false;
            }
        } else if (!b2 && this.connected) {
            try {
                LOG.fine("Attempting to disconnect from the data store");
                this.disconnect();
            }
            catch (Exception e3) {
                LOG.log(Level.WARNING, "Failed to physically disconnect from the data store, but will continue to logically disconnect from the data store.", e3);
            }
            finally {
                this.connected = false;
                LOG.fine("Logically disconnected from the data store, firing property change event");
                this.pcs.firePropertyChange("connected", true, false);
            }
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected abstract void connect() throws Exception;

    protected abstract void disconnect() throws Exception;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }
}

