/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset;

import com.datastax.data.dataset.DataCommand;
import com.datastax.data.dataset.DataConnection;
import com.datastax.data.dataset.DataTable;
import com.datastax.data.dataset.provider.LoadTask;
import com.datastax.data.dataset.provider.SaveTask;
import com.datastax.data.dataset.provider.Task;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public abstract class DataProvider {
    private static final Executor EX = Executors.newCachedThreadPool();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private DataCommand command;
    private DataConnection connection;

    public void load(DataTable[] tables) {
        LoadTask task = this.createLoadTask(tables);
        this.runTask(task);
    }

    public void loadAndWait(DataTable[] tables) {
        LoadTask task = this.createLoadTask(tables);
        task.setLoadOnEDT(false);
        this.runTaskAndWait(task);
    }

    public void load(DataTable t2) {
        this.load(new DataTable[]{t2});
    }

    public void loadAndWait(DataTable t2) {
        this.loadAndWait(new DataTable[]{t2});
    }

    public void save(DataTable t2) {
        this.save(new DataTable[]{t2});
    }

    public void saveAndWait(DataTable t2) {
        this.saveAndWait(new DataTable[]{t2});
    }

    public void save(DataTable[] tables) {
        SaveTask task = this.createSaveTask(tables);
        this.runTask(task);
    }

    public void saveAndWait(DataTable[] tables) {
        SaveTask task = this.createSaveTask(tables);
        this.runTaskAndWait(task);
    }

    protected abstract SaveTask createSaveTask(DataTable[] var1);

    protected abstract LoadTask createLoadTask(DataTable[] var1);

    protected void runTask(Task runner) {
        EX.execute(runner);
    }

    protected void runTaskAndWait(Task runner) {
        runner.run();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void setCommand(DataCommand cmd) {
        if (this.command != cmd) {
            DataCommand oldCommand = this.command;
            this.command = cmd;
            this.pcs.firePropertyChange("command", oldCommand, cmd);
        }
    }

    public DataCommand getCommand() {
        return this.command;
    }

    public void setConnection(DataConnection conn) {
        if (this.connection != conn) {
            DataConnection oldConn = this.connection;
            this.connection = conn;
            this.pcs.firePropertyChange("connection", oldConn, conn);
        }
    }

    public DataConnection getConnection() {
        return this.connection;
    }
}

