/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset;

import com.datastax.data.dataset.DataColumn;
import com.datastax.data.dataset.DataRow;
import com.datastax.data.dataset.DataSet;
import com.datastax.data.dataset.DataSetUtils;
import com.datastax.data.dataset.DataTable;
import com.datastax.data.dataset.NameGenerator;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class DataRelation {
    private static final Logger LOG = Logger.getLogger(DataRelation.class.getName());
    protected static final String DEFAULT_NAME_PREFIX = "DataRelation";
    private static final NameGenerator NAMEGEN = new NameGenerator("DataRelation");
    private DataSet dataSet;
    private String name;
    private DataColumn parentColumn;
    private DataColumn childColumn;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    protected DataRelation(DataSet ds) {
        assert (ds != null);
        this.dataSet = ds;
        this.name = NAMEGEN.generateName(this);
    }

    protected DataRelation(DataSet ds, String name) {
        this(ds);
        if (name != null) {
            this.setName(name);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    void removeFromDataSet() {
        this.dataSet = null;
    }

    public void setName(String name) {
        if (this.name != name) {
            assert (DataSetUtils.isValidName(name));
            assert (!this.dataSet.hasElement(name));
            String oldName = this.name;
            this.name = name;
            this.pcs.firePropertyChange("name", oldName, name);
        }
    }

    public String getName() {
        return this.name;
    }

    public DataColumn getParentColumn() {
        return this.parentColumn;
    }

    public void setParentColumn(DataColumn parentColumn) {
        if (this.parentColumn != parentColumn) {
            assert (parentColumn == null || parentColumn != this.childColumn);
            DataColumn oldValue = this.parentColumn;
            this.parentColumn = parentColumn;
            this.pcs.firePropertyChange("parentColumn", oldValue, parentColumn);
        }
    }

    public DataColumn getChildColumn() {
        return this.childColumn;
    }

    public void setChildColumn(DataColumn childColumn) {
        if (this.childColumn != childColumn) {
            assert (childColumn == null || childColumn != this.parentColumn);
            DataColumn oldValue = this.childColumn;
            this.childColumn = childColumn;
            this.pcs.firePropertyChange("childColumn", oldValue, childColumn);
        }
    }

    public List<DataRow> getRows(DataRow parentRow) {
        if (this.parentColumn == null || this.childColumn == null || parentRow == null) {
            return Collections.unmodifiableList(Collections.EMPTY_LIST);
        }
        assert (parentRow.getTable().equals(this.parentColumn.getTable()));
        DataTable childTable = this.childColumn.getTable();
        Object parentKey = this.parentColumn.getTable().getValue(parentRow, this.parentColumn);
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        for (DataRow childRow : childTable.getRows()) {
            Object childKey = childTable.getValue(childRow, this.childColumn);
            if (parentKey == null || childKey == null || !parentKey.equals(childKey)) continue;
            rows.add(childRow);
        }
        return Collections.unmodifiableList(rows);
    }

    public List<DataRow> getRows(int parentRowIndex) {
        if (this.parentColumn == null || this.childColumn == null || parentRowIndex < 0) {
            return Collections.unmodifiableList(Collections.EMPTY_LIST);
        }
        DataTable parentTable = this.parentColumn.getTable();
        return this.getRows(parentTable.getRow(parentRowIndex));
    }

    public List<DataRow> getRows(DataRow[] parentRows) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        for (DataRow parentRow : parentRows) {
            rows.addAll(this.getRows(parentRow));
        }
        return Collections.unmodifiableList(rows);
    }

    public List<DataRow> getRows(int[] parentRowIndices) {
        if (this.parentColumn == null || this.childColumn == null || parentRowIndices == null) {
            return Collections.unmodifiableList(Collections.EMPTY_LIST);
        }
        DataTable parentTable = this.parentColumn.getTable();
        DataRow[] parentRows = new DataRow[parentRowIndices.length];
        for (int i2 = 0; i2 < parentRows.length; ++i2) {
            parentRows[i2] = parentTable.getRow(parentRowIndices[i2]);
        }
        return this.getRows(parentRows);
    }

    public List<DataRow> getRows(List<Integer> parentRowIndices) {
        if (this.parentColumn == null || this.childColumn == null || parentRowIndices == null) {
            return Collections.unmodifiableList(Collections.EMPTY_LIST);
        }
        DataTable parentTable = this.parentColumn.getTable();
        DataRow[] parentRows = new DataRow[parentRowIndices.size()];
        for (int i2 = 0; i2 < parentRows.length; ++i2) {
            parentRows[i2] = parentTable.getRow(parentRowIndices.get(i2));
        }
        return this.getRows(parentRows);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }
}

