/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset;

import com.datastax.data.dataset.DataColumn;
import com.datastax.data.dataset.DataProvider;
import com.datastax.data.dataset.DataRelation;
import com.datastax.data.dataset.DataRow;
import com.datastax.data.dataset.DataSelector;
import com.datastax.data.dataset.DataSet;
import com.datastax.data.dataset.DataTable;
import com.datastax.data.dataset.event.DataTableListener;
import com.datastax.data.dataset.event.RowChangeEvent;
import com.datastax.data.dataset.event.TableChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public class DataRelationTable
extends DataTable {
    private static final Logger LOG = Logger.getLogger(DataRelationTable.class.getName());
    private DataRelation relation;
    private DataSelector parentSelector;
    private DataTable parentTable;
    private SelectionListener listener = new SelectionListener();
    private ParentTableListener pListener = new ParentTableListener();
    private ChildTableListener cListener = new ChildTableListener();

    public DataRelationTable(DataSet ds) {
        super(ds);
    }

    public DataRelationTable(DataSet ds, String name) {
        super(ds, name);
    }

    public void setRelation(DataRelation relation) {
        if (this.relation != relation) {
            if (this.relation != null && this.relation.getChildColumn() != null) {
                this.relation.getChildColumn().getTable().removeDataTableListener(this.cListener);
            }
            this.relation = relation;
            this.addChildListener();
            if (relation != null) {
                relation.addPropertyChangeListener("childColumn", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        DataRelationTable.this.addChildListener();
                    }
                });
            }
        }
    }

    private void addChildListener() {
        if (this.relation != null && this.relation.getChildColumn() != null) {
            this.relation.getChildColumn().getTable().removeDataTableListener(this.cListener);
        }
        if (this.relation != null && this.relation.getChildColumn() != null) {
            this.relation.getChildColumn().getTable().addDataTableListener(this.cListener);
        }
    }

    public DataRelation getRelation() {
        return this.relation;
    }

    public void setParentSelector(DataSelector selector) {
        if (this.parentSelector != null) {
            this.parentSelector.removePropertyChangeListener("rowIndices", this.listener);
        }
        this.parentSelector = selector;
        if (this.parentSelector != null) {
            this.parentSelector.addPropertyChangeListener("rowIndices", this.listener);
        }
    }

    public DataSelector getParentSelector() {
        return this.parentSelector;
    }

    public void setParentTable(DataTable parent) {
        if (this.parentTable != null) {
            this.parentTable.removeDataTableListener(this.pListener);
        }
        this.parentTable = parent;
        if (this.parentTable != null) {
            this.parentTable.addDataTableListener(this.pListener);
        }
    }

    public DataTable getParentTable() {
        return this.parentTable;
    }

    @Override
    public void setDataProvider(DataProvider dataProvider) {
        LOG.warning("An attempt was made to set the DataProvider for a DataRelationTable. This is not honored because a DataRelationTable, by definition, gets its records by querying a DataSelector from the Parent table, and the DataRelation leading to the Child table.");
    }

    @Override
    public void save() {
        LOG.warning("An attempt was made to save a DataRelationTable. This is not honored because a DataRelationTable, by definition, gets its records by querying a DataSelector from the Parent table, and the DataRelation leading to the Child table. Therefore, to save, the child table should be asked to save, not the DataRelationTable.");
    }

    @Override
    public DataRow appendRow() {
        if (this.relation != null && this.relation.getChildColumn() != null) {
            DataTable t2 = this.relation.getChildColumn().getTable();
            DataRow row = t2.appendRow();
            if (this.parentSelector.getRowIndices().size() == 1) {
                row.setValue(this.relation.getChildColumn().getName(), this.relation.getParentColumn().getTable().getValue(this.parentSelector.getRowIndices().get(0), this.relation.getParentColumn().getName()));
            }
            this.rows.add(row);
            return row;
        }
        return null;
    }

    @Override
    public void refresh() {
        HashMap<DataSelector, Object[][]> selectorState = new HashMap<DataSelector, Object[][]>();
        ArrayList<DataColumn> keyColumns = new ArrayList<DataColumn>();
        for (DataColumn c2 : this.columns.values()) {
            if (!c2.isKeyColumn()) continue;
            keyColumns.add(c2);
        }
        for (DataSelector sel : this.selectors.values()) {
            List<Integer> indices = sel.getRowIndices();
            Object[][] values = new Object[indices.size()][keyColumns.size()];
            for (int i2 = 0; i2 < indices.size(); ++i2) {
                for (int j2 = 0; j2 < keyColumns.size(); ++j2) {
                    DataRow row = (DataRow)this.rows.get(indices.get(i2));
                    values[i2][j2] = this.getValue(row, (DataColumn)keyColumns.get(j2));
                }
            }
            sel.setRowIndices(new int[0]);
            selectorState.put(sel, values);
        }
        this.clear();
        if (this.relation != null && this.relation.getChildColumn() != null) {
            this.fireDataTableChanged(TableChangeEvent.newLoadStartEvent(this));
            if (this.parentSelector != null) {
                this.rows.addAll(this.relation.getRows(this.parentSelector.getRowIndices()));
            } else if (this.parentTable != null) {
                List<DataRow> list = this.parentTable.getRows();
                this.rows.addAll(this.relation.getRows(list.toArray(new DataRow[list.size()])));
            } else {
                this.rows.addAll(this.relation.getChildColumn().getTable().getRows());
            }
            this.fireDataTableChanged(TableChangeEvent.newLoadCompleteEvent(this));
        }
        for (DataSelector sel : this.selectors.values()) {
            Object[][] values = (Object[][])selectorState.get(sel);
            ArrayList<Integer> indices = new ArrayList<Integer>(values.length);
            for (int i3 = 0; i3 < values.length; ++i3) {
                boolean found = true;
                for (int rowIndex = 0; rowIndex < this.rows.size(); ++rowIndex) {
                    found = true;
                    for (int j3 = 0; j3 < keyColumns.size(); ++j3) {
                        DataRow row = (DataRow)this.rows.get(rowIndex);
                        if (found && values[i3][j3].equals(row.getValue((DataColumn)keyColumns.get(j3)))) continue;
                        found = false;
                    }
                    if (!found) continue;
                    indices.add(rowIndex);
                }
            }
            int[] rows = new int[indices.size()];
            for (int i4 = 0; i4 < rows.length; ++i4) {
                rows[i4] = (Integer)indices.get(i4);
            }
            if (this.rows.size() <= 0) continue;
            if (rows.length == 0) {
                sel.setRowIndices(new int[]{0});
                continue;
            }
            sel.setRowIndices(rows);
        }
    }

    @Override
    public DataColumn getColumn(String colName) {
        DataColumn col = null;
        if (this.relation != null && this.relation.getChildColumn() != null && this.relation.getChildColumn().getTable() != null) {
            col = this.relation.getChildColumn().getTable().getColumn(colName);
        }
        if (col == null) {
            return super.getColumn(colName);
        }
        return col;
    }

    @Override
    public List<DataColumn> getColumns() {
        ArrayList<DataColumn> cols = new ArrayList<DataColumn>();
        if (this.relation != null && this.relation.getChildColumn() != null && this.relation.getChildColumn().getTable() != null) {
            cols.addAll(this.relation.getChildColumn().getTable().getColumns());
        }
        cols.addAll(super.getColumns());
        return Collections.unmodifiableList(cols);
    }

    private final class ChildTableListener
    implements DataTableListener {
        private ChildTableListener() {
        }

        @Override
        public void rowChanged(RowChangeEvent evt) {
        }

        @Override
        public void tableChanged(TableChangeEvent evt) {
            DataRelationTable.this.refresh();
        }
    }

    private final class ParentTableListener
    implements DataTableListener {
        private ParentTableListener() {
        }

        @Override
        public void rowChanged(RowChangeEvent evt) {
        }

        @Override
        public void tableChanged(TableChangeEvent evt) {
            DataRelationTable.this.refresh();
        }
    }

    private final class SelectionListener
    implements PropertyChangeListener {
        private SelectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DataRelationTable.this.refresh();
        }
    }
}

