/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset;

import com.datastax.data.dataset.DataColumn;
import com.datastax.data.dataset.DataTable;
import com.datastax.data.dataset.event.RowChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataRow {
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private DataTable table;
    private DataRowStatus status = DataRowStatus.INSERTED;
    private Map<DataColumn, DataCell> cells = new HashMap<DataColumn, DataCell>();

    protected DataRow(DataTable table) {
        assert (table != null);
        this.table = table;
        for (DataColumn col : this.table.getColumns()) {
            this.addCell(col);
        }
    }

    public void setReferenceValue(String colName, Object value) {
        this.setReferenceValue(this.table.getColumn(colName), value);
    }

    public int getCellsCount() {
        return this.cells.size();
    }

    public void setReferenceValue(DataColumn col, Object value) {
        assert (col != null);
        this.getCell(col).setReferenceValue(this.table, col, value);
        DataRowStatus newStatus = this.deriveRowStatus();
        if (newStatus != this.status) {
            this.setStatus(newStatus);
        }
    }

    public void setValue(String colName, Object value) {
        DataColumn col = this.table.getColumn(colName);
        this.setValue(col, value);
    }

    public void setValue(DataColumn col, Object value) {
        assert (col != null);
        Object oldValue = this.getValue(col);
        DataCell cell = this.getCell(col);
        this.getCell(col).setValue(this.table, col, value);
        DataRowStatus oldStatus = this.status;
        DataRowStatus newStatus = this.deriveRowStatus();
        if (newStatus != oldStatus) {
            this.setStatus(newStatus);
        }
        if (!cell.isSame(this.getTable(), col, oldValue, value)) {
            this.fireDataRowChanged(RowChangeEvent.newCellChangedEvent(this, col, oldValue, oldStatus));
        }
    }

    public void resetAllToReferenceValue() {
        List<DataColumn> cols = this.table.getColumns();
        for (DataColumn col : cols) {
            this.resetToReferenceValue(col);
        }
    }

    public void resetToReferenceValue(String colName) {
        this.resetToReferenceValue(this.table.getColumn(colName));
    }

    public void resetToReferenceValue(DataColumn col) {
        this.setValue(col, this.getCell((DataColumn)col).referenceValue);
    }

    public Object getReferenceValue(String colName) {
        return this.getReferenceValue(this.table.getColumn(colName));
    }

    public Object getValue(String colName) {
        return this.getValue(this.table.getColumn(colName));
    }

    public Object getReferenceValue(DataColumn col) {
        assert (col != null);
        String exp = col.getExpression();
        if (exp == null || exp.equals("")) {
            DataCell cell = this.getCell(col);
            return cell.referenceValue;
        }
        return col.getValueForRow(this);
    }

    public Object getValue(DataColumn col) {
        assert (col != null);
        String exp = col.getExpression();
        if (exp == null || exp.equals("")) {
            DataCell cell = this.getCell(col);
            return cell.value;
        }
        return col.getValueForRow(this);
    }

    protected DataCell getCell(DataColumn col) {
        DataCell cell = this.cells.get(col);
        if (cell == null && col.getTable() == this.table) {
            cell = this.addCell(col);
        }
        return cell;
    }

    public DataTable getTable() {
        return this.table;
    }

    void removeFromTable() {
        this.table = null;
    }

    public DataRowStatus getStatus() {
        return this.status;
    }

    public boolean isModified(String colName) {
        return this.isModified(this.table.getColumn(colName));
    }

    public boolean isModified(DataColumn col) {
        return this.cells.get((Object)col).changed;
    }

    public Object getOriginalValue(String colName) {
        return this.getReferenceValue(colName);
    }

    public Object getOriginalValue(DataColumn col) {
        return this.getReferenceValue(col);
    }

    public void setStatus(DataRowStatus status) {
        if (this.status != status) {
            DataRowStatus priorStatus = this.status;
            this.status = status;
            this.pcs.firePropertyChange("status", (Object)priorStatus, (Object)status);
            if (this.status == DataRowStatus.UNCHANGED) {
                List<DataColumn> cols = this.table.getColumns();
                for (DataColumn col : cols) {
                    DataCell cell = this.getCell(col);
                    if (!cell.changed) continue;
                    cell.overwriteReference();
                }
            }
        }
    }

    public int getIndex() {
        return this.table.indexOfRow(this);
    }

    public void fireDataRowChanged(RowChangeEvent evt) {
        this.table.fireRowChanged(evt);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Row #");
        buffer.append(this.table.indexOfRow(this));
        buffer.append(" [ ");
        int i2 = 0;
        for (DataCell c2 : this.cells.values()) {
            buffer.append(c2.value);
            if (i2 < this.cells.size() - 1) {
                buffer.append(", ");
            }
            ++i2;
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    protected DataCell addCell(DataColumn col) {
        DataCell cell = this.cells.get(col);
        if (cell == null) {
            cell = new DataCell(col);
            this.cells.put(col, cell);
        }
        return cell;
    }

    protected DataRowStatus deriveRowStatus() {
        DataRowStatus derived;
        switch (this.status) {
            case INSERTED: 
            case DELETED: {
                derived = this.status;
                break;
            }
            case UPDATED: 
            case UNCHANGED: {
                boolean any = false;
                for (DataCell cell : this.cells.values()) {
                    if (!cell.changed) continue;
                    any = true;
                    break;
                }
                derived = any ? DataRowStatus.UPDATED : DataRowStatus.UNCHANGED;
                break;
            }
            default: {
                throw new RuntimeException("deriveRowStatus() has no case for row status of " + (Object)((Object)this.status));
            }
        }
        return derived;
    }

    private static final class DataCell {
        Object referenceValue;
        Object value;
        boolean changed;
        boolean valueSet;

        DataCell(DataColumn col) {
            this.value = this.referenceValue = col.getDefaultValue();
        }

        public void setReferenceValue(DataTable table, DataColumn col, Object newRef) {
            this.referenceValue = newRef;
            this.changed = this.isSame(table, col, this.referenceValue, newRef);
        }

        public void setValue(DataTable table, DataColumn col, Object newValue) {
            if (!this.valueSet) {
                this.value = this.referenceValue = newValue;
                this.changed = true;
                this.valueSet = true;
                return;
            }
            if (this.isSame(table, col, this.referenceValue, newValue)) {
                this.value = this.referenceValue;
                this.changed = false;
                return;
            }
            if (!this.isSame(table, col, this.value, newValue)) {
                this.value = newValue;
                this.changed = true;
            }
        }

        public void overwriteReference() {
            this.referenceValue = this.value;
            this.changed = false;
        }

        private boolean isSame(DataTable table, DataColumn col, Object baseValue, Object newValue) {
            if (table.isIdentityComparisonEnabled()) {
                return newValue == baseValue;
            }
            Comparator comp = null;
            comp = table.hasColumnComparator(col) ? table.getColumnComparator(col) : table.getClassComparator(col.getType());
            return comp.compare(baseValue, newValue) == 0;
        }
    }

    public static enum DataRowStatus {
        INSERTED,
        DELETED,
        UPDATED,
        UNCHANGED;

    }
}

