/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset;

import com.datastax.data.dataset.DataRow;
import com.datastax.data.dataset.DataTable;
import com.datastax.data.dataset.NameGenerator;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;

public class DataSelector {
    protected static final String DEFAULT_NAME_PREFIX = "DataSelector";
    private static final NameGenerator NAMEGEN = new NameGenerator("DataSelector");
    private DataTable table;
    private String name;
    private BitSet indices = new BitSet(0);
    private int[] helper = new int[1];
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public DataSelector(DataTable table) {
        assert (table != null);
        this.table = table;
        this.name = NAMEGEN.generateName(this);
        if (table != null && table.getRowCount() > 0) {
            this.setRowIndices(new int[]{0});
        }
    }

    public DataTable getDataTable() {
        return this.table;
    }

    public DataTable getTable() {
        return this.table;
    }

    void removeFromTable() {
        this.table = null;
    }

    public void setName(String name) {
        if (this.name != name) {
            assert (name != null && !name.trim().equals(""));
            String oldName = this.name;
            this.name = name;
            this.pcs.firePropertyChange("name", oldName, name);
        }
    }

    public String getName() {
        return this.name;
    }

    public List<Integer> getRowIndices() {
        ArrayList<Integer> results = new ArrayList<Integer>(this.indices.cardinality());
        int n2 = -1;
        for (int i2 = 0; i2 < this.indices.cardinality(); ++i2) {
            n2 = this.indices.nextSetBit(n2 + 1);
            results.add(n2);
        }
        return Collections.unmodifiableList(results);
    }

    public int getFirstRowIndex() {
        return this.indices.cardinality() > 0 ? this.indices.nextSetBit(0) : -1;
    }

    public void setRowIndices(int[] rowIndices) {
        List<Integer> oldIndices = this.getRowIndices();
        this.indices.clear();
        for (int index : rowIndices) {
            this.indices.set(index);
        }
        this.pcs.firePropertyChange("rowIndices", oldIndices, this.getRowIndices());
    }

    public void setRowIndex(int index) {
        assert (index < this.table.getRowCount());
        if (index >= 0) {
            this.helper[0] = index;
            this.setRowIndices(this.helper);
        } else {
            this.setRowIndices(new int[0]);
        }
    }

    public void setRowIndex(DataRow row) {
        assert (row != null);
        this.setRowIndices(new int[]{this.table.indexOfRow(row)});
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }
}

