/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset;

import com.datastax.data.dataset.DataColumn;
import com.datastax.data.dataset.DataRelation;
import com.datastax.data.dataset.DataRelationTable;
import com.datastax.data.dataset.DataRow;
import com.datastax.data.dataset.DataSelector;
import com.datastax.data.dataset.DataSetUtils;
import com.datastax.data.dataset.DataTable;
import com.datastax.data.dataset.DataValue;
import com.datastax.data.dataset.NameGenerator;
import com.datastax.data.dataset.Parser;
import com.datastax.data.dataset.event.TableChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataSet {
    private static final Logger LOG = Logger.getLogger(DataSet.class.getName());
    protected static final String DEFAULT_NAME_PREFIX = "DataSource";
    private static final NameGenerator NAMEGEN = new NameGenerator("DataSource");
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private String name;
    private Map<String, DataTable> tables = new HashMap<String, DataTable>();
    private Map<String, DataRelation> relations = new HashMap<String, DataRelation>();
    private Map<String, DataValue> values = new HashMap<String, DataValue>();
    private Parser parser;
    private NameChangeListener nameChangeListener = new NameChangeListener();

    public DataSet() {
        this.setName(NAMEGEN.generateName(this));
    }

    public DataSet(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        if (this.name != name) {
            assert (DataSetUtils.isValidName(name));
            String oldName = this.name;
            this.name = name;
            this.pcs.firePropertyChange("name", oldName, name);
        }
    }

    public String getName() {
        return this.name;
    }

    public DataTable createTable() {
        return this.createTable(null);
    }

    public DataTable createTable(String name) {
        DataTable table = new DataTable(this, name);
        table.addPropertyChangeListener("name", this.nameChangeListener);
        this.tables.put(table.getName(), table);
        return table;
    }

    public DataRelationTable createRelationTable() {
        return this.createRelationTable(null);
    }

    public DataRelationTable createRelationTable(String name) {
        DataRelationTable table = new DataRelationTable(this, name);
        table.addPropertyChangeListener("name", this.nameChangeListener);
        this.tables.put(table.getName(), table);
        return table;
    }

    public DataRelation createRelation() {
        return this.createRelation(null);
    }

    public DataRelation createRelation(String name) {
        DataRelation relation = new DataRelation(this, name);
        relation.addPropertyChangeListener("name", this.nameChangeListener);
        this.relations.put(relation.getName(), relation);
        return relation;
    }

    public DataValue createValue() {
        return this.createValue(null);
    }

    public DataValue createValue(String name) {
        DataValue value = new DataValue(this, name);
        value.addPropertyChangeListener("name", this.nameChangeListener);
        this.values.put(value.getName(), value);
        return value;
    }

    public void dropTable(DataTable table) {
        this.dropTable(table.getName());
    }

    public void dropTable(String tableName) {
        DataTable table = this.tables.remove(tableName);
        if (table != null) {
            table.removeFromDataSet();
            table.removePropertyChangeListener("name", this.nameChangeListener);
            for (DataRelation r2 : this.relations.values()) {
                DataColumn col = r2.getChildColumn();
                if (col != null && col.getTable() == table) {
                    r2.setChildColumn(null);
                }
                if ((col = r2.getParentColumn()) == null || col.getTable() != table) continue;
                r2.setParentColumn(null);
            }
            for (DataTable t2 : this.tables.values()) {
                if (!(t2 instanceof DataRelationTable)) continue;
                DataRelationTable drt = (DataRelationTable)t2;
                if (drt.getParentTable() == table) {
                    drt.setParentTable(null);
                }
                if (drt.getParentSelector() == null || drt.getParentSelector().getTable() != table) continue;
                drt.setParentSelector(null);
            }
        }
    }

    public void dropRelationTable(DataRelationTable table) {
        this.dropTable(table.getName());
    }

    public void dropRelationTable(String tableName) {
        this.dropTable(tableName);
    }

    public void dropRelation(DataRelation relation) {
        this.dropRelation(relation.getName());
    }

    public void dropRelation(String relationName) {
        DataRelation relation = this.relations.remove(relationName);
        if (relation != null) {
            relation.removeFromDataSet();
            relation.removePropertyChangeListener("name", this.nameChangeListener);
            for (DataTable t2 : this.tables.values()) {
                DataRelationTable drt;
                if (!(t2 instanceof DataRelationTable) || (drt = (DataRelationTable)t2).getRelation() != relation) continue;
                drt.setRelation(null);
            }
        }
    }

    public void dropValue(DataValue value) {
        this.dropValue(value.getName());
    }

    public void dropValue(String valueName) {
        DataValue value = this.values.remove(valueName);
        if (value != null) {
            value.removeFromDataSet();
            value.removePropertyChangeListener("name", this.nameChangeListener);
        }
    }

    protected boolean hasElement(String name) {
        boolean b2 = this.relations.containsKey(name);
        if (!b2) {
            b2 = this.tables.containsKey(name);
        }
        if (!b2) {
            b2 = this.values.containsKey(name);
        }
        return b2;
    }

    public Object getElement(String path) {
        if (path == null) {
            return null;
        }
        if (path.contains(".")) {
            String[] steps = path.split("\\.");
            assert (steps.length == 2);
            DataTable table = this.tables.get(steps[0]);
            DataColumn col = table.getColumn(steps[1]);
            if (col != null) {
                return col;
            }
            return table.getSelector(steps[1]);
        }
        if (this.relations.containsKey(path)) {
            return this.relations.get(path);
        }
        if (this.tables.containsKey(path)) {
            return this.tables.get(path);
        }
        if (this.values.containsKey(path)) {
            return this.values.get(path);
        }
        return null;
    }

    public List<DataRow> getRows(String path) {
        if (path == null || path.trim().equals("")) {
            return Collections.EMPTY_LIST;
        }
        path = path.trim();
        String[] steps = path.split("\\.");
        List<DataRow> workingSet = null;
        for (String step : steps) {
            String name = null;
            String selectorName = null;
            if (step.contains("[")) {
                name = step.substring(0, step.indexOf(91));
                selectorName = step.substring(step.indexOf(91) + 1, step.indexOf(93));
            }
            if (workingSet == null) {
                DataTable table = this.tables.get(name);
                if (table == null) assert (false);
                workingSet = table.getRows();
                if (selectorName == null) continue;
            }
            DataRelation relation = this.relations.get(name);
            if (relation == null) assert (false);
            workingSet = relation.getRows(workingSet.toArray(new DataRow[workingSet.size()]));
            if (selectorName == null) continue;
        }
        return Collections.unmodifiableList(workingSet);
    }

    public List<DataRow> filterRows(List<DataRow> rows, DataSelector ds) {
        List<Integer> indices = ds.getRowIndices();
        ArrayList<DataRow> results = new ArrayList<DataRow>(indices.size());
        for (int index : indices) {
            results.add(rows.get(index));
        }
        return results;
    }

    public List<DataColumn> getColumns(String path) {
        String[] parts = path.split("\\.");
        assert (parts.length == 1 || parts.length == 2);
        DataTable table = this.tables.get(parts[0]);
        if (table == null) {
            DataRelation relation = this.relations.get(parts[0]);
            if (relation == null) {
                return new ArrayList<DataColumn>();
            }
            table = relation.getChildColumn().getTable();
        }
        if (parts.length == 1) {
            return table.getColumns();
        }
        ArrayList<DataColumn> results = new ArrayList<DataColumn>();
        results.add(table.getColumn(parts[1]));
        return Collections.unmodifiableList(results);
    }

    public DataTable getTable(String tableName) {
        return this.tables.get(tableName);
    }

    public List<DataTable> getTables() {
        ArrayList<DataTable> tableList = new ArrayList<DataTable>();
        for (DataTable table : this.tables.values()) {
            tableList.add(table);
        }
        return tableList;
    }

    public DataRelationTable getRelationTable(String name) {
        return (DataRelationTable)this.tables.get(name);
    }

    public DataValue getValue(String valueName) {
        return this.values.get(valueName);
    }

    public List<DataValue> getValues() {
        ArrayList<DataValue> values = new ArrayList<DataValue>();
        for (DataValue v2 : this.values.values()) {
            values.add(v2);
        }
        return values;
    }

    public DataRelation getRelation(String relationName) {
        return this.relations.get(relationName);
    }

    public List<DataRelation> getRelations() {
        ArrayList<DataRelation> relations = new ArrayList<DataRelation>();
        for (DataRelation r2 : this.relations.values()) {
            relations.add(r2);
        }
        return relations;
    }

    public void load() {
        for (DataTable table : this.tables.values()) {
            if (table instanceof DataRelationTable) continue;
            table.load();
        }
    }

    public void loadAndWait() {
        for (DataTable table : this.tables.values()) {
            if (table instanceof DataRelationTable) continue;
            table.loadAndWait();
        }
    }

    public void refresh() {
        for (DataTable table : this.tables.values()) {
            if (table instanceof DataRelationTable) continue;
            table.refresh();
        }
    }

    public void refreshAndWait() {
        for (DataTable table : this.tables.values()) {
            if (table instanceof DataRelationTable) continue;
            table.refreshAndWait();
        }
    }

    public void clear() {
        for (DataTable table : this.tables.values()) {
            if (table instanceof DataRelationTable) continue;
            table.clear();
        }
    }

    public void save() {
        for (DataTable table : this.tables.values()) {
            if (table instanceof DataRelationTable) continue;
            table.save();
        }
    }

    public void saveAndWait() {
        for (DataTable table : this.tables.values()) {
            if (table instanceof DataRelationTable) continue;
            table.saveAndWait();
        }
    }

    Parser getParser() {
        if (this.parser == null || this.parser.isInUse()) {
            this.parser = new Parser(this);
        }
        return this.parser;
    }

    public static DataSet createFromSchema(String schema) {
        return DataSetUtils.createFromXmlSchema(schema);
    }

    public String getSchema() {
        return DataSetUtils.getXmlSchema(this);
    }

    public static DataSet createFromSchema(File f2) throws FileNotFoundException {
        return DataSetUtils.createFromXmlSchema(f2);
    }

    public static DataSet createFromSchema(InputStream is) {
        return DataSetUtils.createFromXmlSchema(is);
    }

    public void readXml(File f2) {
        String xml = "";
        try {
            FileInputStream fis = new FileInputStream(f2);
            this.readXml(fis);
            fis.close();
        }
        catch (Exception e2) {
            LOG.log(Level.SEVERE, "Failed to read xml from file {0}. {1}", new Object[]{f2, e2.getStackTrace()});
        }
    }

    public void readXml(InputStream is) {
        String xml = "";
        try {
            StringBuilder builder = new StringBuilder();
            byte[] bytes = new byte[4096];
            int length = -1;
            while ((length = is.read(bytes)) != -1) {
                builder.append(new String(bytes, 0, length));
            }
            xml = builder.toString();
            this.readXml(xml);
        }
        catch (Exception e2) {
            LOG.log(Level.SEVERE, "Failed to read xml from input stream.", e2);
        }
    }

    public void readXml(String xml) {
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document dom = db.parse(new ByteArrayInputStream(xml.getBytes()));
            XPath xpath = XPathFactory.newInstance().newXPath();
            String path = null;
            for (DataTable table : this.tables.values()) {
                if (table instanceof DataRelationTable) continue;
                table.fireDataTableChanged(TableChangeEvent.newLoadStartEvent(table));
                table.clear();
                if (!table.isAppendRowSupported()) {
                    LOG.fine("Table '" + table.getName() + "' does not support append row; skipping (regardless of input).");
                    continue;
                }
                LOG.finer("loading table " + table.getName());
                path = "/" + this.name + "/" + table.getName();
                NodeList nodes = (NodeList)xpath.evaluate(path, dom, XPathConstants.NODESET);
                LOG.finer("  found " + nodes.getLength() + " rows for path " + path);
                for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
                    Node rowNode = nodes.item(i2);
                    DataRow row = table.appendRowNoEvent();
                    NodeList cols = rowNode.getChildNodes();
                    for (int j2 = 0; j2 < cols.getLength(); ++j2) {
                        Node colNode = cols.item(j2);
                        if (colNode.getNodeType() != 1) continue;
                        String text = colNode.getTextContent();
                        Object val = text;
                        Class type = table.getColumn(colNode.getNodeName()).getType();
                        if (type == BigDecimal.class) {
                            val = new BigDecimal(text);
                        }
                        row.setValue(colNode.getNodeName(), val);
                    }
                    row.setStatus(DataRow.DataRowStatus.UNCHANGED);
                }
                table.fireDataTableChanged(TableChangeEvent.newLoadCompleteEvent(table));
            }
        }
        catch (Exception e2) {
            LOG.log(Level.SEVERE, "Failed to parse xml {0}. {1}", new Object[]{xml, e2.getStackTrace()});
        }
    }

    public String writeXml() {
        return this.writeXml(OutputControl.ALL_ROWS);
    }

    public String writeXml(OutputControl flags) {
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" ?>\n");
        builder.append("<");
        builder.append(this.name);
        builder.append(">\n");
        for (DataTable table : this.tables.values()) {
            if (table instanceof DataRelationTable) continue;
            for (DataRow row : table.rows) {
                if (flags == OutputControl.MODIFIED_ONLY && row.getStatus() == DataRow.DataRowStatus.UNCHANGED) continue;
                builder.append("\t<");
                builder.append(table.getName());
                builder.append(">\n");
                for (DataColumn col : table.columns.values()) {
                    builder.append("\t\t<");
                    builder.append(col.getName());
                    builder.append(">");
                    String val = row.getValue(col) == null ? "" : row.getValue(col).toString();
                    val = val.replaceAll("&", "&amp;");
                    val = val.replaceAll("<", "&lt;");
                    val = val.replaceAll(">", "&gt;");
                    val = val.replaceAll("'", "&apos;");
                    val = val.replaceAll("\"", "&quot;");
                    builder.append(val);
                    builder.append("</");
                    builder.append(col.getName());
                    builder.append(">\n");
                }
                builder.append("\t</");
                builder.append(table.getName());
                builder.append(">\n");
            }
        }
        builder.append("</");
        builder.append(this.name);
        builder.append(">");
        return builder.toString();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("DataSource: ").append(this.name).append("\n");
        for (DataTable table : this.tables.values()) {
            if (table instanceof DataRelationTable) {
                buffer.append("\tDataRelationTable: ").append(table.getName()).append("\n");
            } else {
                buffer.append("\tDataTable: ").append(table.getName()).append("\n");
            }
            for (DataColumn col : table.getColumns()) {
                buffer.append("\t\tDataColumn: ").append(col.getName()).append("\n");
            }
        }
        for (DataRelation relation : this.relations.values()) {
            buffer.append("\tRelation: ").append(relation.getName()).append("\n");
            DataColumn parentColumn = relation.getParentColumn();
            buffer.append("\t\tParentColumn: ").append(parentColumn == null ? "<none>" : parentColumn.getTable().getName()).append(".").append(parentColumn == null ? "<none>" : parentColumn.getName()).append("\n");
            DataColumn childColumn = relation.getChildColumn();
            buffer.append("\t\tChildColumn: ").append(childColumn == null ? "<none>" : childColumn.getTable().getName()).append(".").append(childColumn == null ? "<none>" : childColumn.getName()).append("\n");
        }
        buffer.append(this.getSchema());
        return buffer.toString();
    }

    public static void main(String[] args) {
        long startTime = System.currentTimeMillis();
        try {
            DataSet dataSet = DataSetUtils.createFromXmlSchema(new File("/usr/local/src/databinding/src/test/org/data/dataset/contact.ds"));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        long stopTime = System.currentTimeMillis();
        System.out.println(stopTime - startTime);
    }

    private final class NameChangeListener
    implements PropertyChangeListener {
        private NameChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof DataTable) {
                DataTable table = (DataTable)source;
                DataSet.this.tables.remove(evt.getOldValue());
                DataSet.this.tables.put((String)evt.getNewValue(), table);
            } else if (source instanceof DataRelation) {
                DataRelation relation = (DataRelation)source;
                DataSet.this.relations.remove(evt.getOldValue());
                DataSet.this.relations.put((String)evt.getNewValue(), relation);
            } else if (source instanceof DataValue) {
                DataValue value = (DataValue)source;
                DataSet.this.values.remove(evt.getOldValue());
                DataSet.this.values.put((String)evt.getNewValue(), value);
            }
        }
    }

    public static enum OutputControl {
        ALL_ROWS,
        MODIFIED_ONLY;

    }
}

