/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset;

import com.datastax.data.dataset.DataColumn;
import com.datastax.data.dataset.DataProvider;
import com.datastax.data.dataset.DataRelation;
import com.datastax.data.dataset.DataRelationTable;
import com.datastax.data.dataset.DataSelector;
import com.datastax.data.dataset.DataSet;
import com.datastax.data.dataset.DataTable;
import com.datastax.data.dataset.DataValue;
import com.datastax.data.dataset.provider.sql.JDBCDataConnection;
import com.datastax.data.dataset.provider.sql.SQLCommand;
import com.datastax.data.dataset.provider.sql.SQLDataProvider;
import com.datastax.data.dataset.provider.sql.TableCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DataSetUtils {
    private static final Logger LOG = Logger.getLogger(DataSetUtils.class.getName());

    private DataSetUtils() {
    }

    static boolean isValidName(String name) {
        return name != null && !name.matches(".*[\\s]");
    }

    public static String getXmlSchema(DataSet ds) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<?xml version=\"1.0\" standalone=\"yes\" ?>\n");
        buffer.append("<xs:schema id=\"");
        buffer.append(ds.getName());
        buffer.append("\" targetNamespace=\"http://data.org/tempuri/");
        buffer.append(ds.getName());
        buffer.append(".xsd\" xmlns=\"http://javadesktop.org/tempuri/");
        buffer.append(ds.getName());
        buffer.append(".xsd\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" attributeFormDefault=\"qualified\" elementFormDefault=\"qualified\">\n");
        buffer.append("\t<xs:element name=\"");
        buffer.append(ds.getName());
        buffer.append("\">\n");
        buffer.append("\t\t<xs:complexType>\n");
        buffer.append("\t\t\t<xs:choice maxOccurs=\"unbounded\">\n");
        for (DataTable table : ds.getTables()) {
            if (table instanceof DataRelationTable) continue;
            buffer.append("\t\t\t\t<xs:element name=\"");
            buffer.append(table.getName());
            buffer.append("\" appendRowSupported=\"");
            buffer.append(table.isAppendRowSupported());
            buffer.append("\" deleteRowSupported=\"");
            buffer.append(table.isDeleteRowSupported());
            buffer.append("\">\n");
            buffer.append("\t\t\t\t\t<xs:complexType>\n");
            buffer.append("\t\t\t\t\t\t<xs:sequence>\n");
            for (DataColumn col : table.getColumns()) {
                buffer.append("\t\t\t\t\t\t\t<xs:element name=\"");
                buffer.append(col.getName());
                buffer.append("\" type=\"");
                if (col.getType() == String.class || col.getType() == Character.class) {
                    buffer.append("xs:string");
                } else if (col.getType() == BigDecimal.class) {
                    buffer.append("xs:decimal");
                } else if (col.getType() == Integer.class) {
                    buffer.append("xs:integer");
                } else if (col.getType() == Boolean.class) {
                    buffer.append("xs:boolean");
                } else if (col.getType() == Date.class) {
                    buffer.append("xs:dateTime");
                } else if (col.getType() == Byte.class) {
                    buffer.append("xs:unsignedByte");
                } else {
                    LOG.log(Level.WARNING, "Couldn't find type for xsd for Class {0}", col.getType());
                }
                if (col.getDefaultValue() != null) {
                    buffer.append("\" default=\"");
                    buffer.append(col.getDefaultValue());
                }
                if (!col.isRequired()) {
                    buffer.append("\" minOccurs=\"0");
                }
                buffer.append("\" keyColumn=\"");
                buffer.append(col.isKeyColumn());
                buffer.append("\" readOnly=\"");
                buffer.append(col.isReadOnly());
                if (col.getExpression() != null && !col.getExpression().trim().equals("")) {
                    buffer.append("\" expression=\"");
                    buffer.append(col.getExpression());
                }
                buffer.append("\" />\n");
            }
            buffer.append("\t\t\t\t\t\t</xs:sequence>\n");
            buffer.append("\t\t\t\t\t</xs:complexType>\n");
            buffer.append("\t\t\t\t</xs:element>\n");
        }
        buffer.append("\t\t\t</xs:choice>\n");
        buffer.append("\t\t</xs:complexType>\n");
        buffer.append("\t\t<xs:annotation>\n");
        buffer.append("\t\t\t<xs:appinfo>\n");
        for (DataRelation r2 : ds.getRelations()) {
            buffer.append("\t\t\t\t<dataRelation name=\"");
            buffer.append(r2.getName());
            buffer.append("\" parentColumn=\"");
            DataColumn col = r2.getParentColumn();
            if (col != null) {
                buffer.append(col.getTable().getName());
                buffer.append(".");
                buffer.append(col.getName());
            }
            buffer.append("\" childColumn=\"");
            col = r2.getChildColumn();
            if (col != null) {
                buffer.append(col.getTable().getName());
                buffer.append(".");
                buffer.append(col.getName());
            }
            buffer.append("\" />\n");
        }
        for (DataTable table : ds.getTables()) {
            if (!(table instanceof DataRelationTable)) continue;
            DataRelationTable drt = (DataRelationTable)table;
            buffer.append("\t\t\t\t<dataRelationTable name=\"");
            buffer.append(drt.getName());
            buffer.append("\" relation=\"");
            DataRelation dr = drt.getRelation();
            buffer.append(dr == null ? "" : dr.getName());
            buffer.append("\" parentSelector=\"");
            DataSelector sel = drt.getParentSelector();
            buffer.append(sel == null ? "" : sel.getName());
            buffer.append("\" parentTable=\"");
            DataTable parent = drt.getParentTable();
            buffer.append(parent == null ? "" : parent.getName());
            buffer.append("\" />\n");
        }
        for (DataValue value : ds.getValues()) {
            buffer.append("\t\t\t\t<dataValue name=\"");
            buffer.append(value.getName());
            buffer.append("\" expression=\"");
            if (value.getExpression() != null) {
                buffer.append(value.getExpression());
            }
            buffer.append("\" />\n");
        }
        buffer.append("\t\t\t</xs:appinfo>\n");
        buffer.append("\t\t</xs:annotation>\n");
        buffer.append("\t</xs:element>\n");
        buffer.append("</xs:schema>\n");
        return buffer.toString();
    }

    public static DataSet createFromXmlSchema(String schema) {
        return DataSetUtils.createFromXmlSchema(new StringReader(schema));
    }

    public static DataSet createFromXmlSchema(File f2) throws FileNotFoundException {
        return DataSetUtils.createFromXmlSchema(new FileInputStream(f2));
    }

    public static DataSet createFromXmlSchema(InputStream is) {
        return DataSetUtils.createFromXmlSchema(new InputStreamReader(is));
    }

    public static DataSet createFromXmlSchema(Reader schema) {
        DataSet ds = new DataSet();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            InputSource is = new InputSource(schema);
            parser.parse(is, (DefaultHandler)new DataSetParser(ds));
        }
        catch (Exception e2) {
            LOG.log(Level.SEVERE, "Failed to create DataSource from xml schema from reader {0}. {1}", new Object[]{schema, e2.getStackTrace()});
        }
        return ds;
    }

    public static DataSet createFromDatabaseSchema(JDBCDataConnection conn, String databaseName, String ... names) {
        HashSet<String> set = new HashSet<String>();
        for (String name : names) {
            set.add(name);
        }
        DataSet ds = DataSetUtils.createFromDatabaseSchema(conn.getConnection(), databaseName, set);
        for (DataTable table : ds.getTables()) {
            if (table instanceof DataRelationTable || table.getDataProvider() == null) continue;
            table.getDataProvider().setConnection(conn);
        }
        return ds;
    }

    public static DataSet createFromDatabaseSchema(Connection conn, String databaseName, Set<String> names) {
        DataSet ds = new DataSet();
        try {
            HashSet<String> tableNames = new HashSet<String>();
            for (String name : names) {
                if (name.contains(".")) {
                    tableNames.add(name.substring(0, name.indexOf(".")));
                    continue;
                }
                tableNames.add(name);
            }
            DatabaseMetaData md = conn.getMetaData();
            for (String tableName : tableNames) {
                DataTable table = ds.createTable(tableName);
                if (names.contains(tableName)) {
                    LOG.log(Level.FINE, "Including all columns");
                    ResultSet rs = md.getColumns(databaseName, null, tableName, null);
                    while (rs.next()) {
                        DataColumn col = table.createColumn(rs.getString(4));
                        col.setDefaultValue(rs.getObject(13));
                        col.setReadOnly(false);
                        col.setRequired(rs.getString(18).equals("NO"));
                        col.setType(DataSetUtils.getType(rs.getInt(5)));
                    }
                } else {
                    HashSet<String> colNames = new HashSet<String>();
                    for (String string : names) {
                        if (!string.startsWith(tableName) || !string.contains(".")) continue;
                        String colName = string.substring(string.indexOf(".") + 1);
                        colNames.add(colName);
                    }
                    ResultSet rs = md.getPrimaryKeys(databaseName, null, tableName);
                    while (rs.next()) {
                        colNames.add(rs.getString(4));
                    }
                    LOG.log(Level.FINE, "Including columns: " + colNames);
                    for (String colName : colNames) {
                        rs = md.getColumns(databaseName, null, tableName, colName);
                        while (rs.next()) {
                            DataColumn col = table.createColumn(rs.getString(4));
                            col.setDefaultValue(rs.getObject(13));
                            col.setReadOnly(false);
                            col.setRequired(rs.getString(18).equals("NO"));
                            col.setType(DataSetUtils.getType(rs.getInt(5)));
                        }
                    }
                }
                SQLDataProvider dp = new SQLDataProvider(tableName);
                table.setDataProvider(dp);
            }
            for (String tableName : tableNames) {
                try {
                    ResultSet rs = md.getImportedKeys(databaseName, null, tableName);
                    while (rs.next()) {
                        if (rs.getInt(9) > 1) continue;
                        String childTableName = rs.getString(7);
                        String childColName = rs.getString(8);
                        DataTable dataTable = ds.getTable(tableName);
                        DataColumn parentColumn = dataTable.getColumn(rs.getString(4));
                        DataTable childTable = ds.getTable(childTableName);
                        DataColumn childColumn = childTable.getColumn(childColName);
                        if (parentColumn != null && childColumn != null && parentColumn != childColumn) {
                            DataRelation rel = ds.createRelation(rs.getString(12));
                            rel.setParentColumn(parentColumn);
                            rel.setChildColumn(childColumn);
                            continue;
                        }
                        if (parentColumn != childColumn) continue;
                        LOG.log(Level.FINE, "column identity: {0}.{1} = {2}.{3}", new Object[]{childTableName, childColName, dataTable.getName(), parentColumn.getName()});
                    }
                }
                catch (Exception e2) {
                    LOG.log(Level.INFO, "Failed to create relations for table {0}. {1}", new Object[]{tableName, e2.getStackTrace()});
                }
            }
        }
        catch (Exception e3) {
            LOG.log(Level.SEVERE, "Failed to create schema from database", e3);
        }
        return ds;
    }

    private static Class getType(int type) {
        switch (type) {
            case 2003: {
                return Object.class;
            }
            case -5: {
                return BigInteger.class;
            }
            case -2: {
                return Boolean.class;
            }
            case -7: {
                return Boolean.class;
            }
            case 2004: {
                return byte[].class;
            }
            case 16: {
                return Boolean.class;
            }
            case 1: {
                return Character.class;
            }
            case 2005: {
                return char[].class;
            }
            case 70: {
                return Object.class;
            }
            case 91: {
                return Date.class;
            }
            case 3: {
                return BigDecimal.class;
            }
            case 2001: {
                return Object.class;
            }
            case 8: {
                return BigDecimal.class;
            }
            case 6: {
                return BigDecimal.class;
            }
            case 4: {
                return BigInteger.class;
            }
            case 2000: {
                return Object.class;
            }
            case -4: {
                return byte[].class;
            }
            case -1: {
                return String.class;
            }
            case 0: {
                return Object.class;
            }
            case 2: {
                return BigDecimal.class;
            }
            case 1111: {
                return Object.class;
            }
            case 7: {
                return BigDecimal.class;
            }
            case 2006: {
                return Object.class;
            }
            case 5: {
                return Integer.class;
            }
            case 2002: {
                return Object.class;
            }
            case 92: {
                return Date.class;
            }
            case 93: {
                return Date.class;
            }
            case -6: {
                return Integer.class;
            }
            case -3: {
                return byte[].class;
            }
            case 12: {
                return String.class;
            }
        }
        LOG.log(Level.FINE, "Unsupported type");
        return Object.class;
    }

    private static void printResultSet(ResultSet rs) throws Exception {
        int i2;
        ResultSetMetaData md = rs.getMetaData();
        StringBuilder buffer = new StringBuilder();
        StringBuilder lineBuffer = new StringBuilder();
        for (i2 = 0; i2 < md.getColumnCount(); ++i2) {
            buffer.append(DataSetUtils.pad(md.getColumnName(i2 + 1), ' '));
            for (int j2 = 0; j2 < 20; ++j2) {
                lineBuffer.append("-");
            }
            if (i2 >= md.getColumnCount() - 1) continue;
            buffer.append(" | ");
            lineBuffer.append("---");
        }
        LOG.log(Level.FINE, buffer.toString());
        LOG.log(Level.FINE, lineBuffer.toString());
        buffer = new StringBuilder();
        while (rs.next()) {
            for (i2 = 0; i2 < md.getColumnCount(); ++i2) {
                Object obj = rs.getObject(i2 + 1);
                String data = obj == null ? "<null>" : obj.toString();
                data = DataSetUtils.pad(data, ' ');
                buffer.append(data);
                if (i2 >= md.getColumnCount() - 1) continue;
                buffer.append(" | ");
            }
            buffer.append("\n");
        }
        LOG.log(Level.FINE, buffer.toString());
    }

    private static String pad(String s2, char padChar) {
        if (s2 == null) {
            return "<null>              ";
        }
        if (s2.length() > 20) {
            return s2.substring(0, 20);
        }
        if (s2.length() < 20) {
            StringBuilder buffer = new StringBuilder(s2);
            for (int i2 = s2.length(); i2 < 20; ++i2) {
                buffer.append(padChar);
            }
            return buffer.toString();
        }
        return s2;
    }

    private static final class DataSetParser
    extends DefaultHandler {
        public int elementDepth = 0;
        private Attributes attrs;
        private DataSet ds;
        private DataTable table;
        private DataColumn column;
        private DataProvider dataProvider;

        public DataSetParser(DataSet ds) {
            this.ds = ds == null ? new DataSet() : ds;
        }

        public DataSet getDataSet() {
            return this.ds;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            block36: {
                block37: {
                    this.attrs = atts;
                    if (!qName.equals("xs:element")) break block37;
                    ++this.elementDepth;
                    switch (this.elementDepth) {
                        case 1: {
                            this.ds.setName(this.attrs.getValue("name"));
                            break;
                        }
                        case 2: {
                            this.table = this.ds.createTable(this.attrs.getValue("name"));
                            String val = this.attrs.getValue("appendRowSupported");
                            this.table.setAppendRowSupported(val == null || val.equalsIgnoreCase("true"));
                            val = this.attrs.getValue("deleteRowSupported");
                            this.table.setDeleteRowSupported(val == null || val.equalsIgnoreCase("true"));
                            break;
                        }
                        case 3: {
                            this.column = this.table.createColumn(this.attrs.getValue("name"));
                            String val = this.attrs.getValue("minOccurs");
                            if (val != null && val.equals("")) {
                                this.column.setRequired(true);
                            }
                            this.column.setKeyColumn((val = this.attrs.getValue("keyColumn")) == null ? false : val.equalsIgnoreCase("true"));
                            val = this.attrs.getValue("readOnly");
                            this.column.setReadOnly(val == null ? false : val.equalsIgnoreCase("true"));
                            String defaultValue = this.attrs.getValue("default");
                            val = this.attrs.getValue("type");
                            if (val.equals("xs:string")) {
                                this.column.setType(String.class);
                                if (defaultValue != null && !defaultValue.equals("")) {
                                    this.column.setDefaultValue(defaultValue);
                                }
                            } else if (val.equals("xs:decimal")) {
                                this.column.setType(BigDecimal.class);
                                if (defaultValue != null && !defaultValue.equals("")) {
                                    this.column.setDefaultValue(new BigDecimal(defaultValue));
                                }
                            } else if (val.equals("xs:integer") || val.equals("xs:int")) {
                                this.column.setType(Integer.class);
                                if (defaultValue != null && !defaultValue.equals("")) {
                                    this.column.setDefaultValue(new Integer(defaultValue));
                                }
                            } else if (val.equals("xs:boolean")) {
                                this.column.setType(Boolean.class);
                                if (defaultValue != null && !defaultValue.equals("")) {
                                    this.column.setDefaultValue(Boolean.parseBoolean(defaultValue));
                                }
                            } else if (val.equals("xs:date") || val.equals("xs:time") || val.equals("xs.dateTime")) {
                                this.column.setType(Date.class);
                                if (defaultValue != null && !defaultValue.equals("")) {
                                    this.column.setDefaultValue(new Date(Date.parse(defaultValue)));
                                }
                            } else if (val.equals("xs:unsignedByte")) {
                                this.column.setType(Byte.class);
                                if (defaultValue != null && !defaultValue.equals("")) {
                                    this.column.setDefaultValue(new Byte(defaultValue));
                                }
                            } else {
                                LOG.log(Level.WARNING, "unexpected classType: '{0}'", val);
                            }
                            if ((val = this.attrs.getValue("expression")) != null && !"".equals(val)) {
                                this.column.setExpression(val);
                                break;
                            }
                            break block36;
                        }
                        default: {
                            LOG.log(Level.FINE, "Error in DataSetParser");
                            break;
                        }
                    }
                    break block36;
                }
                if (qName.equals("dataProvider")) {
                    String classType = this.attrs.getValue("class");
                    if (classType != null) {
                        try {
                            this.dataProvider = (DataProvider)Class.forName(classType).newInstance();
                            this.table.setDataProvider(this.dataProvider);
                            if (!(this.dataProvider instanceof SQLDataProvider)) break block36;
                            String tableName = this.attrs.getValue("tableName");
                            if (tableName != null && !tableName.equals("")) {
                                TableCommand cmd = new TableCommand(tableName);
                                cmd.setWhereClause(this.attrs.getValue("whereClause"));
                                cmd.setOrderByClause(this.attrs.getValue("orderByClause"));
                                cmd.setHavingClause(this.attrs.getValue("havingClause"));
                                this.dataProvider.setCommand(cmd);
                                break block36;
                            }
                            SQLCommand command = new SQLCommand();
                            command.setSelectSQL(this.attrs.getValue("select"));
                            command.setInsertSQL(this.attrs.getValue("insert"));
                            command.setUpdateSQL(this.attrs.getValue("update"));
                            command.setDeleteSQL(this.attrs.getValue("delete"));
                            this.dataProvider.setCommand(command);
                        }
                        catch (Exception e2) {
                            LOG.log(Level.WARNING, "Unsupported DataProvider {0}. {1}", new Object[]{classType, e2.getStackTrace()});
                        }
                    }
                } else if (qName.equals("dataRelationTable")) {
                    DataRelationTable drt = this.ds.createRelationTable(this.attrs.getValue("name"));
                    drt.setRelation((DataRelation)this.ds.getElement(this.attrs.getValue("relation")));
                    drt.setParentSelector((DataSelector)this.ds.getElement(this.attrs.getValue("parentSelector")));
                    drt.setParentTable((DataTable)this.ds.getElement(this.attrs.getValue("parentTable")));
                } else if (qName.equals("dataRelation")) {
                    DataRelation relation = this.ds.createRelation(this.attrs.getValue("name"));
                    relation.setParentColumn((DataColumn)this.ds.getElement(this.attrs.getValue("parentColumn")));
                    relation.setChildColumn((DataColumn)this.ds.getElement(this.attrs.getValue("childColumn")));
                } else if (qName.equals("dataValue")) {
                    DataValue value = this.ds.createValue(this.attrs.getValue("name"));
                    value.setExpression(this.attrs.getValue("expression"));
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("xs:element")) {
                switch (this.elementDepth) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        LOG.log(Level.FINE, "Error in DataSetParser");
                    }
                }
                --this.elementDepth;
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }
    }
}

