/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset;

import com.datastax.data.dataset.DataColumn;
import com.datastax.data.dataset.DataProvider;
import com.datastax.data.dataset.DataRelation;
import com.datastax.data.dataset.DataRow;
import com.datastax.data.dataset.DataSelector;
import com.datastax.data.dataset.DataSet;
import com.datastax.data.dataset.DataSetUtils;
import com.datastax.data.dataset.NameGenerator;
import com.datastax.data.dataset.event.DataTableListener;
import com.datastax.data.dataset.event.RowChangeEvent;
import com.datastax.data.dataset.event.TableChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class DataTable {
    private static final Logger LOG = Logger.getLogger(DataTable.class.getName());
    protected static final String DEFAULT_NAME_PREFIX = "DataTable";
    private static final NameGenerator NAMEGEN = new NameGenerator("DataTable");
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private DataSet dataSet;
    private DataProvider dataProvider;
    private String name;
    protected Map<String, DataColumn> columns = new LinkedHashMap<String, DataColumn>();
    protected Map<Class, Comparator> classComparators = new HashMap<Class, Comparator>();
    protected Map<DataColumn, Comparator> columnComparators = new HashMap<DataColumn, Comparator>();
    private static final Comparator EQUALS_COMPARATOR = new Comparator(){

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        public int compare(Object o1, Object o2) {
            return o1.equals(o2) ? 0 : -1;
        }
    };
    protected List<DataRow> rows = new ArrayList<DataRow>();
    protected Map<String, DataSelector> selectors = new HashMap<String, DataSelector>();
    private boolean deleteRowSupported = true;
    private boolean appendRowSupported = true;
    private boolean identityComparisonEnabled;
    private List<DataTableListener> listeners = new ArrayList<DataTableListener>();
    private final PropertyChangeListener nameChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DataColumn c2;
            if (evt.getSource() instanceof DataSelector) {
                DataSelector sel = DataTable.this.selectors.remove(evt.getOldValue());
                if (sel != null) {
                    DataTable.this.selectors.put((String)evt.getNewValue(), sel);
                }
            } else if (evt.getSource() instanceof DataColumn && (c2 = DataTable.this.columns.remove(evt.getOldValue())) != null) {
                DataTable.this.columns.put((String)evt.getNewValue(), c2);
            }
        }
    };

    protected DataTable(DataSet ds) {
        assert (ds != null);
        this.dataSet = ds;
        this.name = NAMEGEN.generateName(this);
        this.identityComparisonEnabled = true;
    }

    protected DataTable(DataSet ds, String name) {
        this(ds);
        if (name != null) {
            this.setName(name);
        }
    }

    public DataColumn createColumn() {
        return this.createColumn(null);
    }

    public DataColumn createColumn(String colName) {
        DataColumn col = new DataColumn(this);
        if (colName != null) {
            col.setName(colName);
        }
        this.columns.put(col.getName(), col);
        col.addPropertyChangeListener("name", this.nameChangeListener);
        this.fireDataTableChanged(TableChangeEvent.newColumnAddedEvent(this, col));
        return col;
    }

    public void createColumns(String ... colNames) {
        for (String name : colNames) {
            this.createColumn(name);
        }
    }

    public void dropColumn(String colName) {
        DataColumn col = this.columns.remove(colName);
        if (col != null) {
            col.removeFromTable();
            col.removePropertyChangeListener("name", this.nameChangeListener);
            for (DataRelation r2 : this.dataSet.getRelations()) {
                DataColumn c2 = r2.getChildColumn();
                if (c2 == col) {
                    r2.setChildColumn(null);
                }
                if ((c2 = r2.getParentColumn()) != col) continue;
                r2.setParentColumn(null);
            }
            this.columnComparators.remove(col);
            this.fireDataTableChanged(TableChangeEvent.newColumnRemovedEvent(this, col));
        }
    }

    public List<DataColumn> getColumns() {
        return Collections.unmodifiableList(new ArrayList<DataColumn>(this.columns.values()));
    }

    public DataColumn getColumn(String colName) {
        return this.columns.get(colName);
    }

    public List<DataRow> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    public DataRow getRow(int index) {
        return this.rows.get(index);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public DataSelector createSelector() {
        return this.createSelector(null);
    }

    public DataSelector createSelector(String name) {
        DataSelector sel = new DataSelector(this);
        if (name != null) {
            sel.setName(name);
        }
        if (this.rows.size() > 0) {
            sel.setRowIndex(0);
        }
        this.selectors.put(sel.getName(), sel);
        sel.addPropertyChangeListener("name", this.nameChangeListener);
        return sel;
    }

    public List<DataSelector> getSelectors() {
        return Collections.unmodifiableList(new ArrayList<DataSelector>(this.selectors.values()));
    }

    public DataSelector getSelector(String name) {
        if (!this.selectors.containsKey(name)) {
            return this.createSelector(name);
        }
        return this.selectors.get(name);
    }

    public void dropSelector(DataSelector selector) {
        this.dropSelector(selector.getName());
    }

    public void dropSelector(String selectorName) {
        DataSelector sel = this.selectors.remove(selectorName);
        if (sel != null) {
            sel.removeFromTable();
            sel.removePropertyChangeListener("name", this.nameChangeListener);
        }
    }

    public void setName(String name) {
        if (this.name != name) {
            assert (DataSetUtils.isValidName(name));
            assert (!this.dataSet.hasElement(name));
            String oldName = this.name;
            this.name = name;
            this.pcs.firePropertyChange("name", oldName, name);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isIdentityComparisonEnabled() {
        return this.identityComparisonEnabled;
    }

    public void setIdentityComparisonEnabled(boolean identityComparisonEnabled) {
        this.identityComparisonEnabled = identityComparisonEnabled;
    }

    public void setClassComparator(Class klass, Comparator comp) {
        assert (klass != null);
        assert (comp != null);
        this.classComparators.put(klass, comp);
    }

    public void removeClassComparator(Class klass) {
        assert (klass != null);
        this.classComparators.remove(klass);
    }

    public boolean hasClassComparator(Class klass) {
        return this.classComparators.get(klass) != null;
    }

    public Comparator getClassComparator(Class klass) {
        Comparator comp = this.classComparators.get(klass);
        if (comp == null) {
            comp = EQUALS_COMPARATOR;
        }
        return comp;
    }

    public void setColumnComparator(DataColumn col, Comparator comp) {
        assert (col != null);
        assert (comp != null);
        this.columnComparators.put(col, comp);
    }

    public void removeColumnComparator(DataColumn col) {
        assert (col != null);
        this.columnComparators.remove(col);
    }

    public boolean hasColumnComparator(DataColumn col) {
        return this.columnComparators.get(col) != null;
    }

    public Comparator getColumnComparator(DataColumn col) {
        assert (col != null);
        Comparator comp = this.columnComparators.get(col);
        if (comp == null) {
            comp = this.getClassComparator(col.getType());
        }
        return comp;
    }

    public boolean isDeleteRowSupported() {
        return this.deleteRowSupported;
    }

    public void setDeleteRowSupported(boolean deleteRowSupported) {
        if (this.deleteRowSupported != deleteRowSupported) {
            boolean oldValue = this.deleteRowSupported;
            this.deleteRowSupported = deleteRowSupported;
            this.pcs.firePropertyChange("deleteRowSupported", oldValue, deleteRowSupported);
        }
    }

    public boolean isAppendRowSupported() {
        return this.appendRowSupported;
    }

    public void setAppendRowSupported(boolean appendRowSupported) {
        if (this.appendRowSupported != appendRowSupported) {
            boolean oldValue = this.appendRowSupported;
            this.appendRowSupported = appendRowSupported;
            this.pcs.firePropertyChange("appendRowSupported", oldValue, appendRowSupported);
        }
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(DataProvider dataProvider) {
        if (this.dataProvider != dataProvider) {
            DataProvider oldValue = this.dataProvider;
            this.dataProvider = dataProvider;
            this.pcs.firePropertyChange("dataProvider", oldValue, dataProvider);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    void removeFromDataSet() {
        this.dataSet = null;
    }

    public DataRow appendRow() {
        DataRow row = this.appendRowNoEvent();
        if (row != null) {
            this.fireDataTableChanged(TableChangeEvent.newRowAddedEvent(this, row));
            if (this.selectors.get("current") == null) {
                this.createSelector("current");
            }
            this.selectors.get("current").setRowIndices(new int[]{this.indexOfRow(row)});
        }
        return row;
    }

    public void appendRow(Object[] row) {
        DataRow dataRow = this.appendRow();
        List<DataColumn> cols = this.getColumns();
        for (int i2 = 0; i2 < row.length; ++i2) {
            dataRow.setValue(cols.get(i2).getName(), row[i2]);
        }
    }

    public void appendRows(Object[][] rows) {
        for (int i2 = 0; i2 < rows.length; ++i2) {
            this.appendRow(rows[i2]);
        }
    }

    public DataRow appendRowNoEvent() {
        if (this.appendRowSupported) {
            DataRow row = new DataRow(this);
            int oldSize = this.rows.size();
            this.rows.add(row);
            if (oldSize == 0 && this.rows.size() > 0) {
                for (DataSelector s2 : this.selectors.values()) {
                    s2.setRowIndices(new int[]{0});
                }
            }
            return row;
        }
        return null;
    }

    public void deleteRow(int rowIndex) {
        assert (rowIndex >= 0 && rowIndex < this.rows.size());
        this.deleteRow(this.rows.get(rowIndex));
    }

    public void deleteRow(DataRow row) {
        assert (row.getTable() == this);
        if (this.deleteRowSupported) {
            row.setStatus(DataRow.DataRowStatus.DELETED);
            this.fireDataTableChanged(TableChangeEvent.newRowDeletedEvent(this, row));
        }
    }

    public void discardRow(int rowIndex) {
        assert (rowIndex >= 0 && rowIndex < this.rows.size());
        DataRow row = this.rows.remove(rowIndex);
        row.removeFromTable();
        this.fireDataTableChanged(TableChangeEvent.newRowDiscardedEvent(this, row));
    }

    public void discardRow(DataRow row) {
        this.discardRow(this.indexOfRow(row));
    }

    public void load() {
        if (this.dataProvider != null) {
            this.fireDataTableChanged(TableChangeEvent.newLoadStartEvent(this));
            this.dataProvider.load(this);
        }
    }

    public void loadAndWait() {
        if (this.dataProvider != null) {
            this.fireDataTableChanged(TableChangeEvent.newLoadStartEvent(this));
            this.dataProvider.loadAndWait(this);
        }
    }

    public void save() {
        if (this.dataProvider != null) {
            this.fireDataTableChanged(TableChangeEvent.newSaveStartEvent(this));
            this.dataProvider.save(this);
        }
    }

    public void saveAndWait() {
        if (this.dataProvider != null) {
            this.fireDataTableChanged(TableChangeEvent.newSaveStartEvent(this));
            this.dataProvider.saveAndWait(this);
        }
    }

    public void clear() {
        this.rows.clear();
        for (DataSelector sel : this.selectors.values()) {
            sel.setRowIndices(new int[0]);
        }
        this.fireDataTableChanged(TableChangeEvent.newTableClearedEvent(this));
    }

    public void refresh() {
        this.clear();
        this.load();
    }

    public void refreshAndWait() {
        this.clear();
        this.loadAndWait();
    }

    public Object getValue(int index, String columnName) {
        assert (index >= 0 && index < this.rows.size());
        assert (this.columns.containsKey(columnName));
        return this.rows.get(index).getValue(columnName);
    }

    public void setValue(int index, String columnName, Object value) {
        assert (index >= 0 && index < this.rows.size());
        assert (this.columns.containsKey(columnName));
        this.rows.get(index).setValue(columnName, value);
    }

    public Object getValue(DataRow row, DataColumn col) {
        assert (row.getTable() == this);
        assert (col.getTable() == this);
        return row.getValue(col);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void addDataTableListener(DataTableListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        if (listener instanceof PropertyChangeListener) {
            this.addPropertyChangeListener((PropertyChangeListener)((Object)listener));
        }
    }

    public void removeDataTableListener(DataTableListener listener) {
        this.listeners.remove(listener);
        if (listener instanceof PropertyChangeListener) {
            this.removePropertyChangeListener((PropertyChangeListener)((Object)listener));
        }
    }

    public void fireDataTableChanged(TableChangeEvent evt) {
        for (DataTableListener listener : new ArrayList<DataTableListener>(this.listeners)) {
            listener.tableChanged(evt);
        }
    }

    public void fireRowChanged(RowChangeEvent evt) {
        for (DataTableListener listener : new ArrayList<DataTableListener>(this.listeners)) {
            listener.rowChanged(evt);
        }
    }

    protected int indexOfRow(DataRow row) {
        return this.rows.indexOf(row);
    }
}

