/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset;

import com.datastax.data.dataset.DataColumn;
import com.datastax.data.dataset.DataSet;
import com.datastax.data.dataset.DataSetUtils;
import com.datastax.data.dataset.NameGenerator;
import com.datastax.data.dataset.Parser;
import com.datastax.data.dataset.event.DataTableEventAdapter;
import com.datastax.data.dataset.event.RowChangeEvent;
import com.datastax.data.dataset.event.TableChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jga.fn.EvaluationException;
import net.sf.jga.fn.Generator;
import net.sf.jga.fn.adaptor.Constant;
import net.sf.jga.parser.GeneratorRef;
import net.sf.jga.parser.ParseException;
import net.sf.jga.parser.UncheckedParseException;

public class DataValue {
    protected static final String DEFAULT_NAME_PREFIX = "DataValue";
    private static final NameGenerator NAMEGEN = new NameGenerator("DataValue");
    private static final Logger LOG = Logger.getLogger(DataValue.class.getName());
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private DataSet dataSet;
    private String name;
    private String expression;
    private Generator<?> exprImpl;
    private Class type = Void.TYPE;
    private boolean isParsing = false;
    private Set sources = new HashSet();
    DataTableEventAdapter listener = new DataTableEventAdapter(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            super.propertyChange(evt);
            this.updateValue();
        }

        @Override
        public void tableLoadComplete(TableChangeEvent evt) {
            this.updateValue();
        }

        @Override
        public void tableCleared(TableChangeEvent evt) {
            this.updateValue();
        }

        @Override
        public void rowAdded(TableChangeEvent evt) {
            this.updateValue();
        }

        @Override
        public void rowDiscarded(TableChangeEvent evt) {
            this.updateValue();
        }

        @Override
        public void cellChanged(RowChangeEvent evt) {
            if (DataValue.this.sources.contains(evt.getColumnAffected())) {
                this.updateValue();
            }
        }

        @Override
        public void columnRemoved(TableChangeEvent evt) {
            if (DataValue.this.sources.contains(evt.getColumnAffected())) {
                this.updateValue();
            }
        }

        @Override
        public void columnChanged(TableChangeEvent evt) {
            if (DataValue.this.sources.contains(evt.getColumnAffected())) {
                this.updateValue();
            }
        }

        private void updateValue() {
            Object value = DataValue.this.getValue();
            DataValue.this.pcs.firePropertyChange("value", null, value);
        }
    };

    public DataValue(DataSet ds) {
        assert (ds != null);
        this.dataSet = ds;
        this.name = NAMEGEN.generateName(this);
    }

    public DataValue(DataSet ds, String name) {
        this(ds);
        if (name != null) {
            this.setName(name);
        }
    }

    public void setName(String name) {
        if (this.name != name) {
            assert (DataSetUtils.isValidName(name));
            String oldName = this.name;
            this.name = name;
            this.pcs.firePropertyChange("name", oldName, name);
        }
    }

    public String getName() {
        return this.name;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    void removeFromDataSet() {
        this.dataSet = null;
        if (this.exprImpl != null) {
            Parser.unregister(this.exprImpl, this.listener, this.sources);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        if (expression == null) {
            expression = "";
        }
        if (!expression.equals(this.expression)) {
            if (this.exprImpl != null) {
                Parser.unregister(this.exprImpl, this.listener, this.sources);
                this.exprImpl = null;
            }
            String oldExpression = this.expression;
            this.expression = expression;
            this.pcs.firePropertyChange("expression", oldExpression, expression);
        }
    }

    public Object getValue() {
        assert (this.dataSet != null);
        if (this.exprImpl == null) {
            this.parseExpression();
        }
        try {
            return this.exprImpl == null ? null : this.exprImpl.gen();
        }
        catch (EvaluationException e2) {
            LOG.log(Level.WARNING, "Cannot evaluate \"" + this.expression + "\": returning null. {1}", new Object[]{this.expression, e2.getMessage()});
            return null;
        }
    }

    public Class getType() {
        if (this.exprImpl == null) {
            this.parseExpression();
        }
        return this.type;
    }

    private void setType(Class type) {
        if (type == null) {
            String msg = "A DataValue's type may not be null";
            throw new IllegalArgumentException(msg);
        }
        if (this.type != type) {
            Class oldType = this.type;
            this.type = type;
            this.pcs.firePropertyChange("type", oldType, type);
        }
    }

    public String toString() {
        return "Value " + this.getName() + " == " + this.getExpression();
    }

    Parser getParser() {
        return this.dataSet.getParser();
    }

    private void parseExpression() {
        if (this.exprImpl != null) {
            return;
        }
        if (this.expression == null || this.expression.equals("")) {
            this.exprImpl = new Constant(null);
            this.setType(Object.class);
            return;
        }
        try {
            if (this.isParsing) {
                throw new UncheckedParseException("Circular Reference Exception");
            }
            this.isParsing = true;
            GeneratorRef gen = this.getParser().parseDataValue(this.expression, this);
            this.setType(gen.getReturnType());
            this.exprImpl = gen.getFunctor();
            this.sources = Parser.register(this.exprImpl, this, this.listener);
        }
        catch (ParseException x2) {
            if (x2.getCause() instanceof UncheckedParseException) {
                throw (UncheckedParseException)x2.getCause();
            }
            x2.printStackTrace();
            LOG.log(Level.WARNING, "The expression [{0}] is not valid. {1}", new Object[]{this.expression, x2.getMessage()});
            this.exprImpl = null;
            this.type = Void.TYPE;
        }
        finally {
            this.isParsing = false;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    boolean dependsOn(Object element) {
        if (element == this) {
            return true;
        }
        for (Object obj : this.sources) {
            if (obj == element) {
                return true;
            }
            if (obj instanceof DataColumn && ((DataColumn)obj).dependsOn(element)) {
                return true;
            }
            if (!(obj instanceof DataValue) || !((DataValue)obj).dependsOn(element)) continue;
            return true;
        }
        return false;
    }
}

