/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset;

import com.datastax.data.dataset.DataColumn;
import com.datastax.data.dataset.DataRow;
import com.datastax.data.dataset.DataSet;
import com.datastax.data.dataset.DataTable;
import com.datastax.data.dataset.DataValue;
import com.datastax.data.dataset.event.DataTableEventAdapter;
import java.io.StringBufferInputStream;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.jga.fn.AdaptorVisitor;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.Generator;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.Visitable;
import net.sf.jga.fn.Visitor;
import net.sf.jga.fn.adaptor.ApplyUnary;
import net.sf.jga.fn.adaptor.Bind;
import net.sf.jga.fn.adaptor.Constant;
import net.sf.jga.fn.adaptor.ConstantUnary;
import net.sf.jga.fn.adaptor.Identity;
import net.sf.jga.fn.algorithm.Accumulate;
import net.sf.jga.fn.algorithm.Count;
import net.sf.jga.fn.algorithm.TransformUnary;
import net.sf.jga.fn.arithmetic.Average;
import net.sf.jga.fn.arithmetic.Plus;
import net.sf.jga.fn.arithmetic.ValueOf;
import net.sf.jga.fn.comparison.Max;
import net.sf.jga.fn.comparison.Min;
import net.sf.jga.fn.property.ArrayBinary;
import net.sf.jga.fn.property.Construct;
import net.sf.jga.fn.property.GetProperty;
import net.sf.jga.fn.property.InvokeMethod;
import net.sf.jga.fn.property.InvokeNoArgMethod;
import net.sf.jga.parser.FunctorRef;
import net.sf.jga.parser.GeneratorRef;
import net.sf.jga.parser.JFXGParser;
import net.sf.jga.parser.ParseException;
import net.sf.jga.parser.UnaryFunctorRef;
import net.sf.jga.parser.UncheckedParseException;
import net.sf.jga.util.ComparableComparator;
import net.sf.jga.util.FilterIterator;

class Parser
extends JFXGParser {
    private DataTable table;
    private boolean inTableContext = false;
    private boolean inUse = false;
    private UnaryFunctor<DataTable, List> getRowsFn = new GetProperty(DataTable.class, "Rows");
    private UnaryFunctor<DataTable, Integer> getRowCountFn = new InvokeNoArgMethod(List.class, "size").compose(this.getRowsFn);
    private UnaryFunctor<DataTable, Iterator> iterateTableFn = new InvokeNoArgMethod(List.class, "iterator").compose(this.getRowsFn);
    private UnaryFunctor<DataValue, ?> getValueFn = new GetProperty(DataValue.class, "Value");
    private Class[] filterCtorArgs = new Class[]{Iterator.class, UnaryFunctor.class};
    private BinaryFunctor<Iterator, UnaryFunctor<DataRow, Boolean>, ? extends Iterator> makeFilterFn = new Construct(this.filterCtorArgs, FilterIterator.class).compose((BinaryFunctor)new ArrayBinary());
    private Object element;

    public Parser(DataSet set) {
        this.bindThis(set);
        this.setUndecoratedDecimal(true);
    }

    synchronized boolean isInUse() {
        return this.inUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized UnaryFunctorRef parseComputedColumn(DataTable table, DataColumn column, String expression) throws ParseException {
        this.inUse = true;
        this.setCurrentTable(table);
        this.element = column;
        try {
            this.ReInit(new StringBufferInputStream(expression));
            UnaryFunctorRef unaryFunctorRef = this.parseUnaryRef(DataRow.class);
            return unaryFunctorRef;
        }
        finally {
            this.setCurrentTable(null);
            this.inUse = false;
            this.element = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized GeneratorRef parseDataValue(String expression, DataValue value) throws ParseException {
        this.inUse = true;
        this.inTableContext = true;
        this.element = value;
        try {
            this.ReInit(new StringBufferInputStream(expression));
            GeneratorRef generatorRef = this.parseGeneratorRef();
            return generatorRef;
        }
        finally {
            this.inTableContext = false;
            this.inUse = false;
            this.element = null;
            this.setCurrentTable(null);
        }
    }

    static Set register(Visitable exp, Object element, DataTableEventAdapter listener) {
        if (exp == null) {
            return new HashSet();
        }
        Registrar registrar = new Registrar(element, listener);
        exp.accept((Visitor)registrar);
        return registrar.sources;
    }

    static void unregister(Visitable exp, DataTableEventAdapter listener, Set dependencies) {
        if (exp != null) {
            exp.accept((Visitor)new Unregistrar(listener));
        }
        dependencies.clear();
    }

    protected FunctorRef reservedWord(String name) throws ParseException {
        DataColumn col;
        DataTable maybeTable;
        if (this.table == null && (maybeTable = ((DataSet)this.getBoundObject()).getTable(name)) != null) {
            this.setCurrentTable(maybeTable);
            return new GeneratorRef((Generator)new Constant((Object)this.table), DataTable.class);
        }
        if (this.table != null && name.equals(this.table.getName())) {
            return new GeneratorRef((Generator)new Constant((Object)this.table), DataTable.class);
        }
        if (this.table != null && (col = this.table.getColumn(name)) != null) {
            col.getType();
            if (col.dependsOn(this.element)) {
                throw new UncheckedParseException("Circular Reference Exception");
            }
            return this.makeColumnRef(this.table, col);
        }
        DataValue maybeValue = ((DataSet)this.getBoundObject()).getValue(name);
        if (maybeValue != null) {
            if (maybeValue.dependsOn(this.element)) {
                throw new UncheckedParseException("Circular Reference Exception");
            }
            return new GeneratorRef(this.getValueFn.bind((Object)maybeValue), maybeValue.getType());
        }
        return null;
    }

    protected FunctorRef reservedField(FunctorRef prefix, String name) throws ParseException {
        if (this.isTableReference(prefix) && this.getReferencedTable(prefix).equals(this.table)) {
            DataColumn col = this.table.getColumn(name);
            if (col == null) {
                String err = "unknown column {0} in table {1}";
                String msg = MessageFormat.format(err, name, this.table.getName());
                throw new ParseException(msg);
            }
            return this.makeColumnRef(this.table, col);
        }
        return super.reservedField(prefix, name);
    }

    protected FunctorRef reservedFunction(String name, FunctorRef[] args) throws ParseException {
        if (this.inTableContext) {
            ConstantUnary filter;
            assert (this.table != null);
            FunctorRef lastArgRef = args[args.length - 1];
            boolean hasFilter = lastArgRef.getReturnType() == Boolean.class;
            Object object = filter = hasFilter ? ((UnaryFunctorRef)lastArgRef).getFunctor() : new ConstantUnary((Object)Boolean.TRUE);
            if ("count".equals(name)) {
                if (hasFilter) {
                    UnaryFunctor countFn = new ValueOf(Integer.class).compose((UnaryFunctor)new Count((UnaryFunctor)filter)).compose(this.iterateTableFn);
                    return new GeneratorRef(countFn.bind((Object)this.table), Integer.class);
                }
                return new GeneratorRef(this.getRowCountFn.bind((Object)this.table), Integer.class);
            }
            UnaryFunctor filterTableFn = hasFilter ? this.makeFilterFn.bind2nd((Object)filter).compose(this.iterateTableFn) : this.iterateTableFn;
            Generator iterateRows = filterTableFn.bind((Object)this.table);
            Class type = args[0].getReturnType();
            if (type.isPrimitive()) {
                type = this.getBoxedType(type);
            }
            TransformUnary xform = new TransformUnary(((UnaryFunctorRef)args[0]).getFunctor());
            if ("avg".equals(name)) {
                this.validateArgument(Number.class, type, name);
                Average avg = new Average(type);
                return new GeneratorRef(avg.generate(xform.generate(iterateRows)), type);
            }
            Max bf = null;
            if ("max".equals(name)) {
                this.validateArgument(Comparable.class, type, name);
                bf = new Max((Comparator)new ComparableComparator());
            } else if ("min".equals(name)) {
                this.validateArgument(Comparable.class, type, name);
                bf = new Min((Comparator)new ComparableComparator());
            } else if ("sum".equals(name)) {
                this.validateArgument(Number.class, type, name);
                bf = new Plus(type);
            }
            if (bf != null) {
                Generator gen = new Accumulate((BinaryFunctor)bf).generate(xform.generate(iterateRows));
                return new GeneratorRef(gen, type);
            }
        }
        return super.reservedFunction(name, args);
    }

    private void setCurrentTable(DataTable table) throws ParseException {
        if (this.table != null && table != null) {
            throw new ParseException("Parser is currently associated with table " + this.table);
        }
        this.table = table;
    }

    private UnaryFunctorRef makeColumnRef(DataTable table, DataColumn column) {
        ApplyUnary args = new ApplyUnary(new UnaryFunctor[]{new Identity(), new ConstantUnary((Object)column)});
        InvokeMethod getValue = new InvokeMethod(DataTable.class, "getValue", new Class[]{DataRow.class, DataColumn.class});
        UnaryFunctor value = getValue.bind1st((Object)table).compose((UnaryFunctor)args);
        return new UnaryFunctorRef(value, DataRow.class, ARG_NAME[0], column.getType());
    }

    private boolean isTableReference(FunctorRef ref) {
        return ref != null && ref.getReturnType().equals(DataTable.class) && ref.getReferenceType() == -2;
    }

    private DataTable getReferencedTable(FunctorRef ref) {
        return (DataTable)((GeneratorRef)ref).getFunctor().gen();
    }

    private void validateArgument(Class reqType, Class foundType, String fnName) throws ParseException {
        if (reqType.isAssignableFrom(foundType)) {
            return;
        }
        String msg = "Unable to compute {0} of type {1}";
        Object[] msgargs = new Object[]{fnName, foundType.getSimpleName()};
        throw new ParseException(MessageFormat.format(msg, msgargs));
    }

    private static class Unregistrar
    extends AdaptorVisitor
    implements ConstantUnary.Visitor,
    TransformUnary.Visitor {
        private DataTableEventAdapter listener;

        public Unregistrar(DataTableEventAdapter listener) {
            this.listener = listener;
        }

        public void visit(ConstantUnary constant) {
            DataTable table;
            Object value = constant.fn(null);
            if (value instanceof DataColumn && (table = ((DataColumn)value).getTable()) != null) {
                table.removeDataTableListener(this.listener);
            }
        }

        public void visit(TransformUnary xform) {
            xform.getFunction().accept((Visitor)this);
        }

        public void visit(Bind bind) {
            super.visit(bind);
            Object value = bind.getConstant();
            if (value instanceof DataTable) {
                DataTable table = (DataTable)value;
                table.removeDataTableListener(this.listener);
            } else if (value instanceof DataValue) {
                DataValue data = (DataValue)value;
                data.removePropertyChangeListener("value", this.listener);
                data.removePropertyChangeListener("expression", this.listener);
            }
        }
    }

    private static class Registrar
    extends AdaptorVisitor
    implements ConstantUnary.Visitor,
    TransformUnary.Visitor {
        private Set sources = new HashSet();
        private Object element;
        private DataTableEventAdapter listener;

        public Registrar(Object element, DataTableEventAdapter listener) {
            this.listener = listener;
            this.element = element;
        }

        public void visit(ConstantUnary constant) {
            Object value = constant.fn(null);
            if (value instanceof DataColumn) {
                DataColumn column = (DataColumn)value;
                column.getTable().addDataTableListener(this.listener);
                this.sources.add(column);
            }
        }

        public void visit(TransformUnary xform) {
            xform.getFunction().accept((Visitor)this);
        }

        public void visit(Bind bind) {
            super.visit(bind);
            Object value = bind.getConstant();
            if (value instanceof DataTable) {
                DataTable table = (DataTable)value;
                table.addDataTableListener(this.listener);
            } else if (value instanceof DataValue) {
                DataValue data = (DataValue)value;
                data.addPropertyChangeListener("value", this.listener);
                data.addPropertyChangeListener("expression", this.listener);
                this.sources.add(data);
            }
        }
    }
}

