/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset.event;

import com.datastax.data.dataset.DataRow;
import com.datastax.data.dataset.event.DataTableListener;
import com.datastax.data.dataset.event.RowChangeEvent;
import com.datastax.data.dataset.event.TableChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DataTableEventAdapter
implements DataTableListener,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(DataTableEventAdapter.class.getName());

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LOG.log(Level.FINE, "propertyChange: {0}", evt);
        if (evt.getSource().getClass() == DataRow.class) {
            LOG.log(Level.FINE, "  is data row");
            DataRow row = (DataRow)evt.getSource();
            if (evt.getPropertyName().equals("status")) {
                LOG.log(Level.FINE, "  is status change");
                this.rowStatusChanged(RowChangeEvent.newRowStatusChangeEvent(row, (DataRow.DataRowStatus)((Object)evt.getOldValue())));
            }
        }
    }

    @Override
    public void rowChanged(RowChangeEvent evt) {
        switch (evt.getEventType()) {
            case ROW_STATUS_CHANGED: {
                this.rowStatusChanged(evt);
                break;
            }
            case CELL_CHANGED: {
                this.cellChanged(evt);
                break;
            }
            default: {
                throw new RuntimeException("Unknown event type on row change event " + (Object)((Object)evt.getEventType()));
            }
        }
    }

    public void rowStatusChanged(RowChangeEvent evt) {
    }

    public void cellChanged(RowChangeEvent evt) {
    }

    @Override
    public void tableChanged(TableChangeEvent evt) {
        switch (evt.getEventType()) {
            case LOAD_STARTED: {
                this.tableLoadStarted(evt);
                break;
            }
            case LOAD_COMPLETE: {
                this.tableLoadComplete(evt);
                break;
            }
            case SAVE_STARTED: {
                this.tableSaveStarted(evt);
                break;
            }
            case SAVE_COMPLETE: {
                this.tableSaveComplete(evt);
                break;
            }
            case TABLE_CLEARED: {
                this.tableCleared(evt);
                break;
            }
            case ROW_ADDED: {
                this.rowAdded(evt);
                break;
            }
            case ROW_DELETED: {
                this.rowDeleted(evt);
                break;
            }
            case ROW_DISCARDED: {
                this.rowDiscarded(evt);
                break;
            }
            case COLUMN_ADDED: {
                this.columnAdded(evt);
                break;
            }
            case COLUMN_REMOVED: {
                this.columnRemoved(evt);
                break;
            }
            case COLUMN_CHANGED: {
                this.columnChanged(evt);
                break;
            }
            default: {
                throw new RuntimeException("Unknown event type on row change event " + (Object)((Object)evt.getEventType()));
            }
        }
    }

    public void tableLoadStarted(TableChangeEvent evt) {
    }

    public void tableLoadComplete(TableChangeEvent evt) {
    }

    public void tableSaveStarted(TableChangeEvent evt) {
    }

    public void tableSaveComplete(TableChangeEvent evt) {
    }

    public void tableCleared(TableChangeEvent evt) {
    }

    public void rowAdded(TableChangeEvent evt) {
    }

    public void rowDeleted(TableChangeEvent evt) {
    }

    public void rowDiscarded(TableChangeEvent evt) {
    }

    public void columnAdded(TableChangeEvent evt) {
    }

    public void columnRemoved(TableChangeEvent evt) {
    }

    public void columnChanged(TableChangeEvent evt) {
    }
}

