/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset.event;

import com.datastax.data.dataset.DataColumn;
import com.datastax.data.dataset.DataRow;
import java.util.EventObject;

public class RowChangeEvent
extends EventObject {
    private EventType eventType;
    private DataColumn columnAffected;
    private Object priorColumnValue;
    private DataRow.DataRowStatus priorRowStatus;

    private RowChangeEvent(DataRow source) {
        super(source);
    }

    public static RowChangeEvent newRowStatusChangeEvent(DataRow source, DataRow.DataRowStatus priorStatus) {
        RowChangeEvent rce = new RowChangeEvent(source);
        rce.eventType = EventType.ROW_STATUS_CHANGED;
        rce.priorRowStatus = priorStatus;
        return rce;
    }

    public static RowChangeEvent newCellChangedEvent(DataRow source, DataColumn col, Object priorValue, DataRow.DataRowStatus priorStatus) {
        RowChangeEvent rce = new RowChangeEvent(source);
        rce.eventType = EventType.CELL_CHANGED;
        rce.columnAffected = col;
        rce.priorColumnValue = priorValue;
        rce.priorRowStatus = priorStatus;
        return rce;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public DataColumn getColumnAffected() {
        return this.columnAffected;
    }

    public Object getPriorColumnValue() {
        return this.priorColumnValue;
    }

    public DataRow.DataRowStatus getPriorRowStatus() {
        return this.priorRowStatus;
    }

    public static enum EventType {
        ROW_STATUS_CHANGED,
        CELL_CHANGED;

    }
}

