/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset.event;

import com.datastax.data.dataset.DataColumn;
import com.datastax.data.dataset.DataRow;
import com.datastax.data.dataset.DataTable;
import java.util.EventObject;

public class TableChangeEvent
extends EventObject {
    private EventType eventType;
    private DataColumn columnAffected;
    private DataRow rowAffected;

    private TableChangeEvent(DataTable source) {
        super(source);
    }

    private TableChangeEvent(DataTable source, EventType what) {
        super(source);
        this.eventType = what;
    }

    private TableChangeEvent(DataTable source, EventType what, DataRow row) {
        this(source, what);
        this.rowAffected = row;
    }

    private TableChangeEvent(DataTable source, EventType what, DataColumn column) {
        this(source, what);
        this.columnAffected = column;
    }

    public static TableChangeEvent newLoadStartEvent(DataTable source) {
        return new TableChangeEvent(source, EventType.LOAD_STARTED);
    }

    public static TableChangeEvent newLoadCompleteEvent(DataTable source) {
        return new TableChangeEvent(source, EventType.LOAD_COMPLETE);
    }

    public static TableChangeEvent newSaveStartEvent(DataTable source) {
        return new TableChangeEvent(source, EventType.SAVE_STARTED);
    }

    public static TableChangeEvent newSaveCompleteEvent(DataTable source) {
        return new TableChangeEvent(source, EventType.SAVE_COMPLETE);
    }

    public static TableChangeEvent newTableClearedEvent(DataTable source) {
        return new TableChangeEvent(source, EventType.TABLE_CLEARED);
    }

    public static TableChangeEvent newColumnAddedEvent(DataTable source, DataColumn col) {
        return new TableChangeEvent(source, EventType.COLUMN_ADDED, col);
    }

    public static TableChangeEvent newColumnRemovedEvent(DataTable source, DataColumn col) {
        return new TableChangeEvent(source, EventType.COLUMN_REMOVED, col);
    }

    public static TableChangeEvent newColumnChangedEvent(DataTable source, DataColumn col) {
        return new TableChangeEvent(source, EventType.COLUMN_CHANGED, col);
    }

    public static TableChangeEvent newRowAddedEvent(DataTable source, DataRow row) {
        return new TableChangeEvent(source, EventType.ROW_ADDED, row);
    }

    public static TableChangeEvent newRowDeletedEvent(DataTable source, DataRow row) {
        return new TableChangeEvent(source, EventType.ROW_DELETED, row);
    }

    public static TableChangeEvent newRowDiscardedEvent(DataTable source, DataRow row) {
        return new TableChangeEvent(source, EventType.ROW_DISCARDED, row);
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public DataRow getRowAffected() {
        return this.rowAffected;
    }

    public DataColumn getColumnAffected() {
        return this.columnAffected;
    }

    @Override
    public String toString() {
        DataTable table = (DataTable)this.getSource();
        switch (this.eventType) {
            case LOAD_STARTED: 
            case LOAD_COMPLETE: 
            case SAVE_STARTED: 
            case SAVE_COMPLETE: 
            case TABLE_CLEARED: {
                return table.getName() + "." + (Object)((Object)this.eventType);
            }
            case ROW_ADDED: 
            case ROW_DELETED: 
            case ROW_DISCARDED: {
                return table.getName() + "." + (Object)((Object)this.eventType) + " " + this.rowAffected;
            }
            case COLUMN_ADDED: 
            case COLUMN_REMOVED: 
            case COLUMN_CHANGED: {
                return table.getName() + "." + (Object)((Object)this.eventType) + " " + this.columnAffected.getName();
            }
        }
        return super.toString();
    }

    public static enum EventType {
        LOAD_STARTED,
        LOAD_COMPLETE,
        SAVE_STARTED,
        SAVE_COMPLETE,
        TABLE_CLEARED,
        ROW_ADDED,
        ROW_DELETED,
        ROW_DISCARDED,
        COLUMN_ADDED,
        COLUMN_REMOVED,
        COLUMN_CHANGED;

    }
}

