/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset.io.schema;

import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class DataSetIOUtility {
    private static final Logger LOG = Logger.getLogger(DataSetIOUtility.class.getName());

    private DataSetIOUtility() {
    }

    public static Class getType(int type) {
        switch (type) {
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                return Object.class;
            }
            case -7: 
            case -2: 
            case 16: {
                return Boolean.class;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return Integer.class;
            }
            case -4: 
            case -3: 
            case 2004: {
                return byte[].class;
            }
            case 1: {
                return Character.class;
            }
            case 2005: {
                return char[].class;
            }
            case 91: 
            case 92: 
            case 93: {
                return Date.class;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return BigDecimal.class;
            }
            case -1: 
            case 12: {
                return String.class;
            }
        }
        LOG.warning("Unsupported JDBC type; type is unknown, so mapping to Object.class. Type value was " + type);
        return Object.class;
    }

    public static Map<String, Set<String>> extractTableList(String ... tableNames) {
        HashMap<String, Set<String>> tables = new HashMap<String, Set<String>>(5);
        for (String name : tableNames) {
            int dotIdx = name.indexOf(".");
            if (dotIdx != -1) {
                String table = name.substring(0, dotIdx);
                String col = name.substring(dotIdx + 1);
                if (!tables.containsKey(table)) {
                    tables.put(table, new HashSet());
                }
                if (tables.get(table) == null) continue;
                ((Set)tables.get(table)).add(col);
                continue;
            }
            tables.put(name, null);
        }
        return tables;
    }

    public static String getDefaultSchemaName(DatabaseMetaData databaseMetaData) {
        String defaultSchemaName = null;
        try {
            ResultSet rs = databaseMetaData.getSchemas();
            boolean found = false;
            while (rs.next() && !found) {
                found = rs.getBoolean("IS_DEFAULT");
                if (!found) continue;
                defaultSchemaName = rs.getString("TABLE_SCHEM");
            }
        }
        catch (Exception e2) {
            defaultSchemaName = null;
        }
        return defaultSchemaName;
    }

    public static List<String> extractColumn(ResultSet tableResultSet, String columnName) {
        ArrayList<String> tables = new ArrayList<String>();
        try {
            while (tableResultSet.next()) {
                tables.add(tableResultSet.getString(columnName));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return tables;
    }

    public static void dumpCatalogDetails(DatabaseMetaData databaseMetaData, PrintWriter pw) {
        try {
            pw.println(databaseMetaData.getCatalogTerm());
            ResultSet rs = databaseMetaData.getCatalogs();
            while (rs.next()) {
                int cnt = rs.getMetaData().getColumnCount();
                while (--cnt >= 0) {
                    pw.println("Col: " + rs.getMetaData().getColumnName(cnt));
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private static PrintWriter getPrintWriter(Writer writer) {
        if (writer instanceof PrintWriter) {
            return (PrintWriter)writer;
        }
        return new PrintWriter(new BufferedWriter(writer));
    }
}

