/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset.io.schema;

import com.datastax.data.dataset.DataColumn;
import com.datastax.data.dataset.DataRelation;
import com.datastax.data.dataset.DataSet;
import com.datastax.data.dataset.DataTable;
import com.datastax.data.dataset.io.schema.DataSetIOUtility;
import com.datastax.data.dataset.io.schema.DataSetSchemaReader;
import com.datastax.data.dataset.io.schema.SchemaReaderException;
import com.datastax.data.dataset.provider.sql.JDBCDataConnection;
import com.datastax.data.dataset.provider.sql.SQLDataProvider;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JDBCDataSetSchemaReader
implements DataSetSchemaReader {
    private JDBCDataConnection jdbcConn;
    private String catalog;
    private String schema;

    public JDBCDataSetSchemaReader(JDBCDataConnection jdbcConn) {
        this(jdbcConn, null, null);
    }

    public JDBCDataSetSchemaReader(JDBCDataConnection jdbcConn, String catalog, String schema) {
        this.jdbcConn = jdbcConn;
        this.catalog = catalog;
        this.schema = schema;
    }

    @Override
    public DataSet readDataSet() throws SchemaReaderException {
        boolean connectState = this.jdbcConn.isConnected();
        if (!connectState) {
            this.jdbcConn.setConnected(true);
        }
        DataSet dataSet = null;
        try {
            Connection conn = this.jdbcConn.getConnection();
            DatabaseMetaData dbMetaData = conn.getMetaData();
            String[] typeArray = new String[]{"TABLE"};
            ResultSet tableResultSet = dbMetaData.getTables(null, null, "%", typeArray);
            List<String> tables = DataSetIOUtility.extractColumn(tableResultSet, "TABLE_NAME");
            tableResultSet.close();
            String[] array = tables.toArray(new String[tables.size()]);
            dataSet = this.readDataSet(array);
        }
        catch (SchemaReaderException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new SchemaReaderException("Could not read schemas to create DataSource", e3);
        }
        finally {
            this.jdbcConn.setConnected(connectState);
        }
        return dataSet;
    }

    @Override
    public DataSet readDataSet(String ... tableNames) throws SchemaReaderException {
        boolean connectState = this.jdbcConn.isConnected();
        if (!connectState) {
            this.jdbcConn.setConnected(true);
        }
        DataSet dataSet = new DataSet();
        try {
            this.addTables(dataSet, tableNames);
            this.addRelations(dataSet, tableNames);
        }
        catch (SchemaReaderException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new SchemaReaderException("Could not read schemas to create DataTables", e3);
        }
        finally {
            this.jdbcConn.setConnected(connectState);
        }
        return dataSet;
    }

    @Override
    public List<String> addTables(DataSet dataSet, String ... tableNames) throws SchemaReaderException {
        ArrayList<String> loadedTables = new ArrayList<String>(tableNames.length);
        boolean connectState = this.jdbcConn.isConnected();
        if (!connectState) {
            this.jdbcConn.setConnected(true);
        }
        try {
            Connection conn = this.jdbcConn.getConnection();
            DatabaseMetaData dbMetaData = conn.getMetaData();
            HashMap tables = new HashMap(5);
            for (String name : tableNames) {
                int dotIdx = name.indexOf(".");
                if (dotIdx != -1) {
                    String table = name.substring(0, dotIdx);
                    String col = name.substring(dotIdx + 1);
                    if (!tables.containsKey(table)) {
                        tables.put(table, new HashSet());
                    }
                    if (tables.get(table) == null) continue;
                    ((Set)tables.get(table)).add(col);
                    continue;
                }
                tables.put(name, null);
            }
            for (String tableName : tables.keySet()) {
                if (dataSet.getTable(tableName) != null) {
                    System.out.println("SKIPPING TABLE " + tableName + " ALREADY IN DATASET");
                    continue;
                }
                Set cols = (Set)tables.get(tableName);
                ArrayList<String> colNames = cols == null ? null : new ArrayList<String>(cols);
                String tableSelectCmd = this.getTableSelectNoRowsCommand(tableName, colNames);
                DataTable dataTable = this.readDataTable(dataSet, tableName, tableSelectCmd);
                SQLDataProvider dataProvider = new SQLDataProvider(tableName);
                dataProvider.setConnection(this.jdbcConn);
                dataTable.setDataProvider(dataProvider);
                loadedTables.add(tableName);
            }
        }
        catch (SchemaReaderException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new SchemaReaderException("Could not read schemas to create DataTables", e3);
        }
        finally {
            this.jdbcConn.setConnected(connectState);
        }
        return loadedTables;
    }

    @Override
    public List<String> addRelations(DataSet dataSet, String ... tableNames) throws SchemaReaderException {
        ArrayList<String> loadedRelations = new ArrayList<String>();
        boolean connectState = this.jdbcConn.isConnected();
        if (!connectState) {
            this.jdbcConn.setConnected(true);
        }
        Connection conn = this.jdbcConn.getConnection();
        try {
            List<DataTable> dataTables = dataSet.getTables();
            for (String tableName : tableNames) {
                DataTable dataTable = dataSet.getTable(tableName);
                DatabaseMetaData md = conn.getMetaData();
                ResultSet rs = md.getImportedKeys(conn.getCatalog(), null, dataTable.getName());
                while (rs.next()) {
                    if (rs.getInt("KEY_SEQ") > 1) continue;
                    DataTable parentTable = null;
                    String pkTableName = rs.getString("PKTABLE_NAME");
                    for (DataTable t2 : dataTables) {
                        if (!t2.getName().equalsIgnoreCase(pkTableName)) continue;
                        parentTable = t2;
                        break;
                    }
                    if (parentTable == null) continue;
                    DataColumn parentColumn = parentTable.getColumn(rs.getString("PKCOLUMN_NAME"));
                    DataColumn childColumn = dataTable.getColumn(rs.getString("FKCOLUMN_NAME"));
                    if (parentColumn == null || childColumn == null || parentColumn == childColumn) continue;
                    String name = rs.getString("FK_NAME");
                    if (dataSet.getRelation(name) != null) {
                        dataSet.dropRelation(name);
                    }
                    DataRelation rel = dataSet.createRelation(rs.getString("FK_NAME"));
                    rel.setParentColumn(parentColumn);
                    rel.setChildColumn(childColumn);
                    loadedRelations.add(rel.getName());
                }
            }
        }
        catch (Exception e2) {
            throw new SchemaReaderException("Could not create data relations", e2);
        }
        finally {
            this.jdbcConn.setConnected(connectState);
        }
        return loadedRelations;
    }

    protected String getTableSelectNoRowsCommand(String tableName, List<String> columnNames) {
        String comma = ", \n";
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        if (columnNames == null) {
            builder.append("*\n");
        } else {
            for (String col : columnNames) {
                builder.append(col + comma);
            }
            builder.delete(builder.length() - comma.length(), builder.length() - 1);
        }
        builder.append("FROM " + tableName + "\n");
        builder.append("WHERE 1 = 0");
        return builder.toString();
    }

    private DataTable readDataTable(DataSet dataSet, String tableName, String tableSelectCmd) throws SchemaReaderException {
        boolean connectState = this.jdbcConn.isConnected();
        if (!connectState) {
            this.jdbcConn.setConnected(true);
        }
        Connection conn = this.jdbcConn.getConnection();
        DataTable dataTable = null;
        try {
            DatabaseMetaData dbMetaData = conn.getMetaData();
            Statement stmt = conn.createStatement();
            ResultSetMetaData colRSMD = stmt.executeQuery(tableSelectCmd).getMetaData();
            dataTable = dataSet.createTable(tableName);
            int colCnt = colRSMD.getColumnCount();
            String catalog = colRSMD.getCatalogName(1);
            String schema = colRSMD.getSchemaName(1);
            for (int i2 = 1; i2 <= colCnt; ++i2) {
                String colName = colRSMD.getColumnName(i2);
                DataColumn newColumn = dataTable.createColumn(colName);
                newColumn.setRequired(colRSMD.isNullable(i2) == 1);
                newColumn.setReadOnly(colRSMD.isReadOnly(i2));
                newColumn.setType(DataSetIOUtility.getType(colRSMD.getColumnType(i2)));
                String columnPattern = "%";
                ResultSet colRS = dbMetaData.getColumns(catalog, schema, tableName, columnPattern);
                if (!colRS.next()) continue;
                newColumn.setDefaultValue(colRS.getObject("COLUMN_DEF"));
                colRS.close();
            }
            ResultSet rs = dbMetaData.getPrimaryKeys(catalog, schema, tableName);
            while (rs.next()) {
                DataColumn col = dataTable.getColumn(rs.getString("COLUMN_NAME"));
                if (col == null) continue;
                col.setKeyColumn(true);
            }
            SQLDataProvider dataProvider = new SQLDataProvider(tableName);
            dataProvider.setConnection(this.jdbcConn);
            dataTable.setDataProvider(dataProvider);
        }
        catch (Exception e2) {
            dataSet.dropTable(tableName);
            throw new SchemaReaderException("Could not create DataTable for table named " + tableName, e2);
        }
        finally {
            this.jdbcConn.setConnected(connectState);
        }
        return dataTable;
    }
}

