/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset.io.schema;

import com.datastax.data.dataset.DataColumn;
import com.datastax.data.dataset.DataProvider;
import com.datastax.data.dataset.DataRelation;
import com.datastax.data.dataset.DataRelationTable;
import com.datastax.data.dataset.DataSelector;
import com.datastax.data.dataset.DataSet;
import com.datastax.data.dataset.DataTable;
import com.datastax.data.dataset.DataValue;
import com.datastax.data.dataset.io.schema.DataSetSchemaReader;
import com.datastax.data.dataset.io.schema.SchemaReaderException;
import com.datastax.data.dataset.provider.sql.SQLCommand;
import com.datastax.data.dataset.provider.sql.SQLDataProvider;
import com.datastax.data.dataset.provider.sql.TableCommand;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDataSetSchemaReader
implements DataSetSchemaReader {
    private String xmlContents;
    private DataSetParser lastParserUsed;

    public XMLDataSetSchemaReader(InputStream xmlInputStream) throws SchemaReaderException {
        this(new InputStreamReader(xmlInputStream));
    }

    public XMLDataSetSchemaReader(Reader xmlReader) throws SchemaReaderException {
        String xml = "";
        if (!(xmlReader instanceof BufferedReader)) {
            xmlReader = new BufferedReader(xmlReader);
        }
        try {
            StringBuilder builder = new StringBuilder();
            char[] bytes = new char[4096];
            int length = -1;
            while ((length = xmlReader.read(bytes)) != -1) {
                builder.append(new String(bytes, 0, length));
            }
            this.xmlContents = builder.toString();
        }
        catch (Exception e2) {
            throw new SchemaReaderException("Can't read input stream to parse schema from.", e2);
        }
    }

    @Override
    public DataSet readDataSet() throws SchemaReaderException {
        return this.readXml(new DataSet(), new String[0]);
    }

    @Override
    public DataSet readDataSet(String ... tableNames) throws SchemaReaderException {
        return this.readXml(new DataSet(), tableNames);
    }

    @Override
    public List<String> addRelations(DataSet dataSet, String ... tableNames) throws SchemaReaderException {
        this.readXml(dataSet, tableNames);
        return this.lastParserUsed.getRelationsAdded();
    }

    @Override
    public List<String> addTables(DataSet dataSet, String ... tableNames) throws SchemaReaderException {
        this.readXml(dataSet, tableNames);
        return this.lastParserUsed.getTablesAdded();
    }

    private DataSet readXml(DataSet dataSet, String ... tableNames) throws SchemaReaderException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            InputSource is = new InputSource(new StringReader(this.xmlContents));
            this.lastParserUsed = new DataSetParser(dataSet, tableNames);
            parser.parse(is, (DefaultHandler)this.lastParserUsed);
        }
        catch (Exception e2) {
            throw new SchemaReaderException("Failed to setup schema XML parser.", e2);
        }
        return dataSet;
    }

    private static final class DataSetParser
    extends DefaultHandler {
        public int elementDepth = 0;
        private Attributes attrs;
        private DataSet ds;
        private DataTable table;
        private DataColumn column;
        private DataProvider dataProvider;
        private List<String> tableNames;
        private List<String> tablesAdded;
        private List<String> relationsAdded;

        public DataSetParser(DataSet ds, String ... tableNames) {
            this.ds = ds == null ? new DataSet() : ds;
            this.tableNames = new ArrayList<String>(tableNames.length);
            Collections.addAll(this.tableNames, tableNames);
        }

        public DataSet getDataSet() {
            return this.ds;
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this.tablesAdded = new ArrayList<String>();
            this.relationsAdded = new ArrayList<String>();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            block43: {
                block44: {
                    this.attrs = atts;
                    if (!qName.equals("xs:element")) break block44;
                    ++this.elementDepth;
                    switch (this.elementDepth) {
                        case 1: {
                            this.ds.setName(this.attrs.getValue("name"));
                            break;
                        }
                        case 2: {
                            String tableName = this.attrs.getValue("name");
                            if (this.ds.getTable(tableName) != null) {
                                System.out.println("TABLE " + tableName + " ALREADY IN DATASET; SKIPPING.");
                                this.table = null;
                                break;
                            }
                            if (this.tableNames.size() > 0 && !this.tableNames.contains(tableName)) {
                                this.table = null;
                                break;
                            }
                            this.table = this.ds.createTable(tableName);
                            String val = this.attrs.getValue("appendRowSupported");
                            this.table.setAppendRowSupported(val == null || val.equalsIgnoreCase("true"));
                            val = this.attrs.getValue("deleteRowSupported");
                            this.table.setDeleteRowSupported(val == null || val.equalsIgnoreCase("true"));
                            this.tablesAdded.add(tableName);
                            break;
                        }
                        case 3: {
                            if (this.table == null) break;
                            this.column = this.table.createColumn(this.attrs.getValue("name"));
                            String val = this.attrs.getValue("minOccurs");
                            if (val != null && val.equals("")) {
                                this.column.setRequired(true);
                            }
                            this.column.setKeyColumn((val = this.attrs.getValue("keyColumn")) == null ? false : val.equalsIgnoreCase("true"));
                            val = this.attrs.getValue("readOnly");
                            this.column.setReadOnly(val == null ? false : val.equalsIgnoreCase("true"));
                            String defaultValue = this.attrs.getValue("default");
                            val = this.attrs.getValue("type");
                            if (val.equals("xs:string")) {
                                this.column.setType(String.class);
                                if (defaultValue != null && !defaultValue.equals("")) {
                                    this.column.setDefaultValue(defaultValue);
                                }
                            } else if (val.equals("xs:decimal")) {
                                this.column.setType(BigDecimal.class);
                                if (defaultValue != null && !defaultValue.equals("")) {
                                    this.column.setDefaultValue(new BigDecimal(defaultValue));
                                }
                            } else if (val.equals("xs:integer") || val.equals("xs:int")) {
                                this.column.setType(Integer.class);
                                if (defaultValue != null && !defaultValue.equals("")) {
                                    this.column.setDefaultValue(new Integer(defaultValue));
                                }
                            } else if (val.equals("xs:boolean")) {
                                this.column.setType(Boolean.class);
                                if (defaultValue != null && !defaultValue.equals("")) {
                                    this.column.setDefaultValue(Boolean.parseBoolean(defaultValue));
                                }
                            } else if (val.equals("xs:date") || val.equals("xs:time") || val.equals("xs:dateTime")) {
                                this.column.setType(Date.class);
                                if (defaultValue != null && !defaultValue.equals("")) {
                                    this.column.setDefaultValue(new Date(Date.parse(defaultValue)));
                                }
                            } else if (val.equals("xs:unsignedByte")) {
                                this.column.setType(Byte.class);
                                if (defaultValue != null && !defaultValue.equals("")) {
                                    this.column.setDefaultValue(new Byte(defaultValue));
                                }
                            } else {
                                System.err.println("unexpected classType: '" + val + "'");
                            }
                            if ((val = this.attrs.getValue("expression")) != null && !"".equals(val)) {
                                this.column.setExpression(val);
                                break;
                            }
                            break block43;
                        }
                        default: {
                            System.out.println("Error in DataSetParser");
                            break;
                        }
                    }
                    break block43;
                }
                if (qName.equals("dataProvider")) {
                    String classType = this.attrs.getValue("class");
                    if (classType != null) {
                        try {
                            this.dataProvider = (DataProvider)Class.forName(classType).newInstance();
                            this.table.setDataProvider(this.dataProvider);
                            if (!(this.dataProvider instanceof SQLDataProvider)) break block43;
                            String tableName = this.attrs.getValue("tableName");
                            if (tableName != null && !tableName.equals("")) {
                                TableCommand cmd = new TableCommand(tableName);
                                cmd.setWhereClause(this.attrs.getValue("whereClause"));
                                cmd.setOrderByClause(this.attrs.getValue("orderByClause"));
                                cmd.setHavingClause(this.attrs.getValue("havingClause"));
                                this.dataProvider.setCommand(cmd);
                                break block43;
                            }
                            SQLCommand command = new SQLCommand();
                            command.setSelectSQL(this.attrs.getValue("select"));
                            command.setInsertSQL(this.attrs.getValue("insert"));
                            command.setUpdateSQL(this.attrs.getValue("update"));
                            command.setDeleteSQL(this.attrs.getValue("delete"));
                            this.dataProvider.setCommand(command);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                } else if (qName.equals("dataRelationTable")) {
                    DataRelationTable drt = this.ds.createRelationTable(this.attrs.getValue("name"));
                    drt.setRelation((DataRelation)this.ds.getElement(this.attrs.getValue("relation")));
                    drt.setParentSelector((DataSelector)this.ds.getElement(this.attrs.getValue("parentSelector")));
                    drt.setParentTable((DataTable)this.ds.getElement(this.attrs.getValue("parentTable")));
                } else if (qName.equals("dataRelation")) {
                    String relationName = this.attrs.getValue("name");
                    String parentColumnName = this.attrs.getValue("parentColumn");
                    String childColumnName = this.attrs.getValue("childColumn");
                    String parentTableName = parentColumnName.substring(0, parentColumnName.indexOf("."));
                    String childTableName = childColumnName.substring(0, childColumnName.indexOf("."));
                    try {
                        if (this.tableNames.size() > 0 && this.tableNames.contains(parentTableName) && this.tableNames.contains(childTableName)) {
                            DataColumn parentColumn = (DataColumn)this.ds.getElement(parentColumnName);
                            DataColumn childColumn = (DataColumn)this.ds.getElement(childColumnName);
                            if (parentColumn != null && childColumn != null) {
                                if (this.ds.getRelation(relationName) != null) {
                                    this.ds.dropRelation(relationName);
                                }
                                DataRelation relation = this.ds.createRelation(relationName);
                                relation.setParentColumn(parentColumn);
                                relation.setChildColumn(childColumn);
                                this.relationsAdded.add(relationName);
                            }
                            break block43;
                        }
                        System.err.println("DataRelation: Either parent " + parentColumnName + " or child " + childColumnName + " is missing in DataSource. Tables might not be loaded, or the respective columns might not be. Skipping.");
                    }
                    catch (Exception e3) {
                        System.out.println("failed on Parent: " + parentColumnName);
                    }
                } else if (qName.equals("dataValue")) {
                    DataValue value = this.ds.createValue(this.attrs.getValue("name"));
                    value.setExpression(this.attrs.getValue("expression"));
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("xs:element")) {
                switch (this.elementDepth) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        System.out.println("Error in DataSetParser");
                    }
                }
                --this.elementDepth;
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        public List<String> getTablesAdded() {
            return this.tablesAdded;
        }

        public List<String> getRelationsAdded() {
            return this.relationsAdded;
        }
    }
}

