/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset.io.schema;

import com.datastax.data.dataset.DataColumn;
import com.datastax.data.dataset.DataRelation;
import com.datastax.data.dataset.DataRelationTable;
import com.datastax.data.dataset.DataSelector;
import com.datastax.data.dataset.DataSet;
import com.datastax.data.dataset.DataTable;
import com.datastax.data.dataset.DataValue;
import com.datastax.data.dataset.io.schema.DataSetIOUtility;
import com.datastax.data.dataset.io.schema.DataSetSchemaWriter;
import com.datastax.data.dataset.io.schema.SchemaWriterException;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class XMLDataSetSchemaWriter
implements DataSetSchemaWriter {
    private PrintWriter outputPrintWriter;

    public XMLDataSetSchemaWriter(OutputStream os) {
        if (!(os instanceof BufferedOutputStream)) {
            os = new BufferedOutputStream(os);
        }
        this.outputPrintWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
    }

    public XMLDataSetSchemaWriter(Writer writer) {
        if (writer instanceof PrintWriter) {
            this.outputPrintWriter = (PrintWriter)writer;
        } else {
            if (writer instanceof BufferedWriter) {
                writer = new BufferedWriter(writer);
            }
            this.outputPrintWriter = new PrintWriter(writer);
        }
    }

    @Override
    public void writeDataSet(DataSet ds) throws SchemaWriterException {
        this.writeXmlSchema(ds, "");
        this.outputPrintWriter.flush();
    }

    @Override
    public void writeDataSet(DataSet ds, String ... tableNames) throws SchemaWriterException {
        this.writeXmlSchema(ds, tableNames);
        this.outputPrintWriter.flush();
    }

    private void writeXmlSchema(DataSet ds, String ... tableNames) {
        Set<String> cols;
        PrintWriter pw = this.outputPrintWriter;
        boolean allTables = tableNames.length == 1 && tableNames[0].length() == 0;
        pw.println("<?xml version=\"1.0\" standalone=\"yes\" ?>");
        pw.print("<xs:schema id=\"");
        pw.print(ds.getName());
        pw.print("\" targetNamespace=\"http://data.org/tempuri/");
        pw.print(ds.getName());
        pw.print(".xsd\" xmlns=\"http://javadesktop.org/tempuri/");
        pw.print(ds.getName());
        pw.println(".xsd\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" attributeFormDefault=\"qualified\" elementFormDefault=\"qualified\">");
        pw.print("\t<xs:element name=\"");
        pw.print(ds.getName());
        pw.println("\">");
        pw.println("\t\t<xs:complexType>");
        pw.println("\t\t\t<xs:choice maxOccurs=\"unbounded\">");
        Map<String, Set<String>> tables = DataSetIOUtility.extractTableList(tableNames);
        for (DataTable table : ds.getTables()) {
            if (table instanceof DataRelationTable) continue;
            String tableName = table.getName();
            if (!allTables && !tables.containsKey(tableName)) continue;
            pw.print("\t\t\t\t<xs:element name=\"");
            pw.print(tableName);
            pw.print("\" appendRowSupported=\"");
            pw.print(table.isAppendRowSupported());
            pw.print("\" deleteRowSupported=\"");
            pw.print(table.isDeleteRowSupported());
            pw.println("\">");
            pw.println("\t\t\t\t\t<xs:complexType>");
            pw.println("\t\t\t\t\t\t<xs:sequence>");
            for (DataColumn col : table.getColumns()) {
                String columnName = col.getName();
                cols = tables.get(tableName);
                if (!allTables && !cols.contains(columnName)) continue;
                pw.print("\t\t\t\t\t\t\t<xs:element name=\"");
                pw.print(col.getName());
                pw.print("\" type=\"");
                if (col.getType() == String.class || col.getType() == Character.class) {
                    pw.print("xs:string");
                } else if (col.getType() == BigDecimal.class) {
                    pw.print("xs:decimal");
                } else if (col.getType() == Integer.class) {
                    pw.print("xs:integer");
                } else if (col.getType() == Boolean.class) {
                    pw.print("xs:boolean");
                } else if (col.getType() == Date.class) {
                    pw.print("xs:dateTime");
                } else if (col.getType() == Byte.class) {
                    pw.print("xs:unsignedByte");
                } else {
                    System.out.println("Couldn't find type for xsd for Class " + col.getType());
                }
                if (col.getDefaultValue() != null) {
                    pw.print("\" default=\"");
                    pw.print(col.getDefaultValue());
                }
                if (!col.isRequired()) {
                    pw.print("\" minOccurs=\"0");
                }
                pw.print("\" keyColumn=\"");
                pw.print(col.isKeyColumn());
                pw.print("\" readOnly=\"");
                pw.print(col.isReadOnly());
                if (col.getExpression() != null && !col.getExpression().trim().equals("")) {
                    pw.print("\" expression=\"");
                    pw.print(col.getExpression());
                }
                pw.println("\" />");
            }
            pw.println("\t\t\t\t\t\t</xs:sequence>");
            pw.println("\t\t\t\t\t</xs:complexType>");
            pw.println("\t\t\t\t</xs:element>");
        }
        pw.println("\t\t\t</xs:choice>");
        pw.println("\t\t</xs:complexType>");
        pw.println("\t\t<xs:annotation>");
        pw.println("\t\t\t<xs:appinfo>");
        for (DataRelation r2 : ds.getRelations()) {
            DataColumn parentCol = r2.getParentColumn();
            DataColumn childCol = r2.getChildColumn();
            String parentTableName = parentCol.getTable().getName();
            String childTableName = childCol.getTable().getName();
            if (!allTables && (!tables.containsKey(parentTableName) || !tables.containsKey(childTableName))) continue;
            cols = null;
            cols = tables.get(parentTableName);
            if (!allTables && !cols.contains(parentCol.getName())) continue;
            cols = tables.get(childTableName);
            if (!allTables && !cols.contains(childCol.getName())) continue;
            pw.print("\t\t\t\t<dataRelation name=\"");
            pw.print(r2.getName());
            pw.print("\" parentColumn=\"");
            if (parentCol != null) {
                pw.print(parentCol.getTable().getName());
                pw.print(".");
                pw.print(parentCol.getName());
            }
            pw.print("\" childColumn=\"");
            if (childCol != null) {
                pw.print(childCol.getTable().getName());
                pw.print(".");
                pw.print(childCol.getName());
            }
            pw.println("\" />");
        }
        for (DataTable table : ds.getTables()) {
            if (!(table instanceof DataRelationTable)) continue;
            DataRelationTable drt = (DataRelationTable)table;
            if (!allTables && !tables.containsKey(drt.getParentTable().getName())) continue;
            pw.print("\t\t\t\t<dataRelationTable name=\"");
            pw.print(drt.getName());
            pw.print("\" relation=\"");
            DataRelation dr = drt.getRelation();
            pw.print(dr == null ? "" : dr.getName());
            pw.print("\" parentSelector=\"");
            DataSelector sel = drt.getParentSelector();
            pw.print(sel == null ? "" : sel.getName());
            pw.print("\" parentTable=\"");
            DataTable parent = drt.getParentTable();
            pw.print(parent == null ? "" : parent.getName());
            pw.println("\" />");
        }
        for (DataValue value : ds.getValues()) {
            pw.print("\t\t\t\t<dataValue name=\"");
            pw.print(value.getName());
            pw.print("\" expression=\"");
            if (value.getExpression() != null) {
                pw.print(value.getExpression());
            }
            pw.println("\" />");
        }
        pw.println("\t\t\t</xs:appinfo>");
        pw.println("\t\t</xs:annotation>");
        pw.println("\t</xs:element>");
        pw.println("</xs:schema>");
    }
}

